/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import java.io.StringWriter;
import java.io.Writer;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.TMXWriter;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.PensieveSeeker;
import net.sf.okapi.tm.pensieve.tmx.OkapiTmxExporter;
import net.sf.okapi.tm.pensieve.tmx.OkapiTmxImporter;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.PensieveWriter;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TmxHandlerExportIT {
    LocaleId locEN = LocaleId.fromString((String)"EN");
    LocaleId locIT = LocaleId.fromString((String)"IT");
    private FileLocation root;

    @Before
    public void setUP() {
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void exportTmx_sample_metadata() throws Exception {
        ByteBuffersDirectory ramDir = new ByteBuffersDirectory();
        PensieveWriter tmWriter = new PensieveWriter((Directory)ramDir, true);
        OkapiTmxImporter tmxImporter = new OkapiTmxImporter(this.locEN, (IFilter)new TmxFilter());
        OkapiTmxExporter tmxExporter = new OkapiTmxExporter();
        tmxImporter.importTmx(this.root.in("/sample_tmx.xml").asUri(), this.locIT, (ITmWriter)tmWriter);
        tmWriter.close();
        PensieveSeeker seeker = new PensieveSeeker((Directory)ramDir);
        StringWriter sWriter = new StringWriter();
        tmxExporter.exportTmx(this.locEN, this.locIT, (ITmSeeker)seeker, new TMXWriter(new XMLWriter((Writer)sWriter)));
        String expectedTmx = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><tmx version=\"1.4\"><header creationtool=\"pensieve\" creationtoolversion=\"0.0.1\" segtype=\"sentence\" o-tmf=\"pensieve\" adminlang=\"en\" srclang=\"en\" datatype=\"unknown\"></header><body><tu tuid=\"hello123\"><prop type=\"Txt::GroupName\">ImAGroupie</prop><prop type=\"Txt::FileName\">GeorgeInTheJungle.hdf</prop><tuv xml:lang=\"en\"><seg>hello</seg></tuv><tuv xml:lang=\"it\"><seg>ciao</seg></tuv></tu><tu tuid=\"world\"><tuv xml:lang=\"en\"><seg>world</seg></tuv><tuv xml:lang=\"it\"><seg>mondo</seg></tuv></tu></body></tmx>";
        Assert.assertEquals((String)"tmx content", (Object)expectedTmx.replaceAll("[\\n\\r]+", ""), (Object)sWriter.toString().replaceAll("[\\n\\r]+", ""));
    }
}

