/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.tm.pensieve.common.MetadataType;
import net.sf.okapi.tm.pensieve.common.TmHit;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.seeker.ITmSeeker;
import net.sf.okapi.tm.pensieve.seeker.PensieveSeeker;
import net.sf.okapi.tm.pensieve.seeker.TmSeekerFactory;
import net.sf.okapi.tm.pensieve.tmx.OkapiTmxImporter;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.PensieveWriter;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TmxHandlerImportIT {
    private static final LocaleId locENUS = LocaleId.fromString((String)"EN-US");
    private static final LocaleId locDEDE = LocaleId.fromString((String)"DE-DE");
    private static final LocaleId locEN = LocaleId.fromString((String)"EN");
    private static final LocaleId locIT = LocaleId.fromString((String)"IT");
    private ITmSeeker seeker;
    private FileLocation root;

    @Before
    public void setUP() {
        this.root = FileLocation.fromClass(this.getClass());
        this.seeker = TmSeekerFactory.createFileBasedTmSeeker((String)this.root.in("/").toString());
    }

    @After
    public void tearDown() {
        if (this.seeker != null) {
            this.seeker.close();
        }
    }

    @Test
    public void importTmx_paragraph_tmx_basics() throws Exception {
        TmxFilter tmxFilter = new TmxFilter();
        ByteBuffersDirectory ramDir = new ByteBuffersDirectory();
        PensieveWriter tmWriter = new PensieveWriter((Directory)ramDir, true);
        OkapiTmxImporter tmxHandler = new OkapiTmxImporter(locENUS, (IFilter)tmxFilter);
        tmxHandler.importTmx(this.root.in("/Paragraph_TM.tmx").asUri(), locDEDE, (ITmWriter)tmWriter);
        tmWriter.close();
        try (PensieveSeeker seeker = new PensieveSeeker((Directory)ramDir);){
            TranslationUnit tu = ((TmHit)seeker.searchExact(new TextFragment("Pumps have been paused for 3 minutes. Consider starting a saline drip."), null).get(0)).getTu();
            Assert.assertEquals((String)"tu target content", (Object)"Pumpen wurden 3 Minuten lang angehalten, ggf. NaCl-Infusion starten", (Object)tu.getTarget().getContent().toText());
        }
    }

    @Test
    public void importTmx_sample_tmx_basics() throws Exception {
        TmxFilter tmxFilter = new TmxFilter();
        ByteBuffersDirectory ramDir = new ByteBuffersDirectory();
        PensieveWriter tmWriter = new PensieveWriter((Directory)ramDir, true);
        OkapiTmxImporter tmxHandler = new OkapiTmxImporter(locEN, (IFilter)tmxFilter);
        tmxHandler.importTmx(this.root.in("/sample_tmx.xml").asUri(), locIT, (ITmWriter)tmWriter);
        tmWriter.close();
        try (PensieveSeeker seeker = new PensieveSeeker((Directory)ramDir);){
            TranslationUnit tu = ((TmHit)seeker.searchExact(new TextFragment("hello"), null).get(0)).getTu();
            Assert.assertEquals((String)"tu target content", (Object)"ciao", (Object)tu.getTarget().getContent().toText());
            Assert.assertEquals((String)"tu source content", (Object)"hello", (Object)tu.getSource().getContent().toText());
            tu = ((TmHit)seeker.searchExact(new TextFragment("world"), null).get(0)).getTu();
            Assert.assertEquals((String)"tu target content", (Object)"mondo", (Object)tu.getTarget().getContent().toText());
            Assert.assertEquals((String)"tu source content", (Object)"world", (Object)tu.getSource().getContent().toText());
        }
    }

    @Test
    public void importTmx_sample_metadata() throws Exception {
        TmxFilter tmxFilter = new TmxFilter();
        ByteBuffersDirectory ramDir = new ByteBuffersDirectory();
        PensieveWriter tmWriter = new PensieveWriter((Directory)ramDir, true);
        OkapiTmxImporter tmxHandler = new OkapiTmxImporter(locEN, (IFilter)tmxFilter);
        tmxHandler.importTmx(this.root.in("/sample_tmx.xml").asUri(), locIT, (ITmWriter)tmWriter);
        tmWriter.close();
        try (PensieveSeeker seeker = new PensieveSeeker((Directory)ramDir);){
            TranslationUnit tu = ((TmHit)seeker.searchExact(new TextFragment("hello"), null).get(0)).getTu();
            Assert.assertEquals((String)"# of metadata (not ignored)", (long)4L, (long)tu.getMetadata().size());
            Assert.assertEquals((String)"tu id", (Object)"hello123", (Object)tu.getMetadata().get((Object)MetadataType.ID));
            Assert.assertEquals((String)"tu FileName", (Object)"GeorgeInTheJungle.hdf", (Object)tu.getMetadata().get((Object)MetadataType.FILE_NAME));
            Assert.assertEquals((String)"tu GroupName", (Object)"ImAGroupie", (Object)tu.getMetadata().get((Object)MetadataType.GROUP_NAME));
            Assert.assertEquals((String)"tu Type", (Object)"plaintext", (Object)tu.getMetadata().get((Object)MetadataType.TYPE));
        }
    }
}

