/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.logger.EventLogger;
import net.sf.okapi.common.logger.TextUnitLogger;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinebuilder.XBatch;
import net.sf.okapi.common.pipelinebuilder.XBatchItem;
import net.sf.okapi.common.pipelinebuilder.XParameter;
import net.sf.okapi.common.pipelinebuilder.XPipeline;
import net.sf.okapi.common.pipelinebuilder.XPipelineStep;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.IWithAnnotations;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.connectors.pensieve.Parameters;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.filters.plaintext.PlainTextFilter;
import net.sf.okapi.lib.reporting.IReportGenerator;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.leveraging.LeveragingStep;
import net.sf.okapi.steps.scopingreport.ScopingReportStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.wordcount.CharacterCountStep;
import net.sf.okapi.steps.wordcount.WordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXFuzzyMatchCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXFuzzyMatchWordCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXLeveragedMatchedCharacterCountStep;
import net.sf.okapi.steps.wordcount.categorized.gmx.GMXLeveragedMatchedWordCountStep;
import net.sf.okapi.steps.wordcount.common.BaseCountStep;
import net.sf.okapi.steps.wordcount.common.BaseCounter;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TmStepsIT {
    private static final LocaleId locENUS = LocaleId.fromString((String)"EN-US");
    private static final LocaleId locFRFR = LocaleId.fromString((String)"FR-FR");
    private static final LocaleId locESES = LocaleId.fromString((String)"ES-ES");
    static FileLocation root;
    static String dbDirectory;
    private BaseCountStep bcs;
    private StartDocument sd;
    private Event sdEvent;
    private ITextUnit tu;
    private Event tuEvent;
    private IReportGenerator gen;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @BeforeClass
    public static void createTestTm() {
        root = FileLocation.fromClass(TmStepsIT.class);
        dbDirectory = root.out("/testtm").toString() + File.separator;
        Util.createDirectories((String)dbDirectory);
        ITmWriter writer = TmWriterFactory.createFileBasedTmWriter((String)dbDirectory, (boolean)true);
        TranslationUnit tu = new TranslationUnit();
        TranslationUnitVariant tuv = new TranslationUnitVariant(locENUS, new TextFragment("Elephants cannot fly."));
        tu.setSource(tuv);
        tuv = new TranslationUnitVariant(locFRFR, new TextFragment("Les \u00e9l\u00e9phants ne peuvent pas voler."));
        tu.setTarget(tuv);
        writer.indexTranslationUnit(tu);
        tu = new TranslationUnit();
        TextFragment tf = new TextFragment("Elephants ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("cannot");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" fly.");
        tuv = new TranslationUnitVariant(locENUS, tf);
        tu.setSource(tuv);
        tf = new TextFragment("Les \u00e9l\u00e9phants ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("ne peuvent pas");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" voler.");
        tuv = new TranslationUnitVariant(locFRFR, tf);
        tu.setTarget(tuv);
        writer.indexTranslationUnit(tu);
        tu = new TranslationUnit();
        tf = new TextFragment("Elephants ");
        tf.append(TextFragment.TagType.OPENING, "g0", "<g0>");
        tf.append("cannot");
        tf.append(TextFragment.TagType.CLOSING, "g0", "</g0>");
        tf.append(" fly.");
        tuv = new TranslationUnitVariant(locENUS, tf);
        tu.setSource(tuv);
        tf = new TextFragment("Les \u00e9l\u00e9phants ");
        tf.append(TextFragment.TagType.OPENING, "g0", "<g0>");
        tf.append("ne peuvent pas");
        tf.append(TextFragment.TagType.CLOSING, "g0", "</g0>");
        tf.append(" voler.");
        tuv = new TranslationUnitVariant(locFRFR, tf);
        tu.setTarget(tuv);
        writer.indexTranslationUnit(tu);
        writer.close();
    }

    private static void testPath(String path) {
        Logger localLogger = LoggerFactory.getLogger(TmStepsIT.class);
        localLogger.debug(new File(path).getAbsolutePath());
    }

    private void startupGmxTest() {
        this.sd = new StartDocument("sd");
        this.sd.setLocale(LocaleId.ENGLISH);
        this.sdEvent = new Event(EventType.START_DOCUMENT, (IResource)this.sd);
        this.tu = new TextUnit("tu");
        this.tu.setSource(new TextContainer("12:00 is 15 minutes after 11:45. You can check at freetime@example.com 8-) for $300"));
        this.tuEvent = new Event(EventType.TEXT_UNIT, (IResource)this.tu);
        root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void testGMXExactMatchedWordCountStep() {
        this.startupGmxTest();
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        this.tu.setSource(new TextContainer("Elephants cannot fly."));
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(99);
        params.setFillTarget(true);
        ls.handleEvent(this.sdEvent);
        ls.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        AltTranslationsAnnotation ata = (AltTranslationsAnnotation)this.tu.getTarget(LocaleId.FRENCH).getAnnotation(AltTranslationsAnnotation.class);
        ata.add(new AltTranslation(LocaleId.ENGLISH, LocaleId.FRENCH, this.tu.getSource().getFirstContent(), null, null, MatchType.EXACT_UNIQUE_ID, 100, null));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        this.bcs = new GMXLeveragedMatchedWordCountStep();
        this.bcs.setSourceLocale(LocaleId.ENGLISH);
        this.bcs.setTargetLocale(LocaleId.FRENCH);
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        Assert.assertEquals((long)3L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"LeveragedMatchedWordCount"));
    }

    @Test
    public void testGMXExactMatchedCharacterCountStep() {
        this.startupGmxTest();
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        this.tu.setSource(new TextContainer("Elephants cannot fly."));
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(99);
        params.setFillTarget(true);
        ls.handleEvent(this.sdEvent);
        ls.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        AltTranslationsAnnotation ata = (AltTranslationsAnnotation)this.tu.getTarget(LocaleId.FRENCH).getAnnotation(AltTranslationsAnnotation.class);
        ata.add(new AltTranslation(LocaleId.ENGLISH, LocaleId.FRENCH, this.tu.getSource().getFirstContent(), null, null, MatchType.EXACT_UNIQUE_ID, 100, null));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        this.bcs = new GMXLeveragedMatchedCharacterCountStep();
        this.bcs.setSourceLocale(LocaleId.ENGLISH);
        this.bcs.setTargetLocale(LocaleId.FRENCH);
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        Assert.assertEquals((long)18L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"LeveragedMatchedCharacterCount"));
    }

    @Test
    public void testGMXLeveragedMatchedWordCountStep() {
        this.startupGmxTest();
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        this.tu.setSource(new TextContainer("Elephants cannot fly."));
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(99);
        params.setFillTarget(true);
        ls.handleEvent(this.sdEvent);
        ls.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        this.bcs = new GMXLeveragedMatchedWordCountStep();
        this.bcs.setSourceLocale(LocaleId.ENGLISH);
        this.bcs.setTargetLocale(LocaleId.FRENCH);
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        Assert.assertEquals((long)3L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"LeveragedMatchedWordCount"));
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"FuzzyMatchedWordCount"));
    }

    @Test
    public void testGMXLeveragedMatchedCharacterCountStep() {
        this.startupGmxTest();
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        this.tu.setSource(new TextContainer("Elephants cannot fly."));
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(99);
        params.setFillTarget(true);
        ls.handleEvent(this.sdEvent);
        ls.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        this.bcs = new GMXLeveragedMatchedCharacterCountStep();
        this.bcs.setSourceLocale(LocaleId.ENGLISH);
        this.bcs.setTargetLocale(LocaleId.FRENCH);
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        Assert.assertEquals((long)18L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"LeveragedMatchedCharacterCount"));
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"FuzzyMatchedCharacterCount"));
    }

    @Test
    public void testGMXFuzzyMatchWordCountStep() {
        this.startupGmxTest();
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        this.tu.setSource(new TextContainer("Elephants cannot fly here."));
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(50);
        params.setFillTarget(true);
        ls.handleEvent(this.sdEvent);
        ls.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        this.bcs = new GMXFuzzyMatchWordCountStep();
        this.bcs.setSourceLocale(LocaleId.ENGLISH);
        this.bcs.setTargetLocale(LocaleId.FRENCH);
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        Assert.assertEquals((long)4L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"FuzzyMatchedWordCount"));
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"LeveragedMatchedWordCount"));
    }

    @Test
    public void testGMXFuzzyMatchCharacterCountStep() {
        this.startupGmxTest();
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        this.tu.setSource(new TextContainer("Elephants cannot fly here."));
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(50);
        params.setFillTarget(true);
        ls.handleEvent(this.sdEvent);
        ls.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        this.bcs = new GMXFuzzyMatchCharacterCountStep();
        this.bcs.setSourceLocale(LocaleId.ENGLISH);
        this.bcs.setTargetLocale(LocaleId.FRENCH);
        this.bcs.handleEvent(this.sdEvent);
        this.bcs.handleEvent(this.tuEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)this.tu, (LocaleId)LocaleId.ENGLISH));
        Assert.assertEquals((long)22L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"FuzzyMatchedCharacterCount"));
        Assert.assertEquals((long)0L, (long)BaseCounter.getCount((IWithAnnotations)this.tu, (String)"LeveragedMatchedCharacterCount"));
    }

    @Test
    public void testLeveraging() {
        Parameters params = new Parameters();
        params.setDbDirectory(dbDirectory);
        new XPipeline("HTML report test", new XBatch(new XBatchItem[]{new XBatchItem(root.in("test.txt").asUrl(), "UTF-8", locENUS, locESES)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep((IFilter)new PlainTextFilter()), new EventLogger(), new XPipelineStep((IPipelineStep)new SegmentationStep(), new XParameter[]{new XParameter("sourceSrxPath", root.in("default.srx").toString()), new XParameter("trimSrcLeadingWS", net.sf.okapi.steps.segmentation.Parameters.TRIM_YES), new XParameter("trimSrcTrailingWS", net.sf.okapi.steps.segmentation.Parameters.TRIM_YES)}), new XPipelineStep((IPipelineStep)new LeveragingStep(), new XParameter[]{new XParameter("resourceClassName", PensieveTMConnector.class.getName()), new XParameter("resourceParameters", params.toString(), true), new XParameter("threshold", 60), new XParameter("fillTarget", true)}), new WordCountStep(), new TextUnitLogger(), new XPipelineStep((IPipelineStep)new ScopingReportStep(), new XParameter[]{new XParameter("projectName", "Test Scoping Report"), new XParameter("outputPath", root.out("test_scoping_report3.html").toString())})}).execute();
        this.logger.debug(root.out("/").toString());
    }

    @Test
    public void test_a_word_is_counted_only_once() {
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        String outputFilePath = root.out("test_scoping_report4.txt").toString();
        String goldFilePath = root.in("gold/test_scoping_report4.txt").toString();
        Event sbEvent = new Event(EventType.START_BATCH);
        Event ebEvent = new Event(EventType.END_BATCH);
        Event siEvent = new Event(EventType.START_BATCH_ITEM);
        Event eiEvent = new Event(EventType.END_BATCH_ITEM);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        Event sdEvent = new Event(EventType.START_DOCUMENT, (IResource)sd);
        Ending ed = new Ending("ed");
        Event edEvent = new Event(EventType.END_DOCUMENT, (IResource)ed);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("Elephants cannot fly."));
        Event tuEvent1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("Elephants can't fly."));
        Event tuEvent2 = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        TextUnit tu3 = new TextUnit("tu3");
        tu3.setSource(new TextContainer("Elephants can fly."));
        Event tuEvent3 = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        TextUnit tu4 = new TextUnit("tu4");
        tu4.setSource(new TextContainer("Airplanes can fly."));
        Event tuEvent4 = new Event(EventType.TEXT_UNIT, (IResource)tu4);
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(60);
        params.setFillTarget(true);
        WordCountStep wcs = new WordCountStep();
        ScopingReportStep srs = new ScopingReportStep();
        srs.setSourceLocale(LocaleId.ENGLISH);
        srs.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.scopingreport.Parameters params2 = (net.sf.okapi.steps.scopingreport.Parameters)srs.getParameters();
        params2.setOutputPath(outputFilePath);
        params2.setCustomTemplateURI(root.in("golden_file_template.txt").toString());
        sd.setName(params2.getCustomTemplateURI());
        wcs.handleEvent(sbEvent);
        wcs.handleEvent(siEvent);
        wcs.handleEvent(sdEvent);
        wcs.handleEvent(tuEvent1);
        wcs.handleEvent(tuEvent2);
        wcs.handleEvent(tuEvent3);
        wcs.handleEvent(tuEvent4);
        wcs.handleEvent(edEvent);
        wcs.handleEvent(eiEvent);
        wcs.handleEvent(ebEvent);
        ls.handleEvent(sbEvent);
        ls.handleEvent(siEvent);
        ls.handleEvent(sdEvent);
        ls.handleEvent(tuEvent1);
        ls.handleEvent(tuEvent2);
        ls.handleEvent(tuEvent3);
        ls.handleEvent(tuEvent4);
        ls.handleEvent(edEvent);
        ls.handleEvent(eiEvent);
        ls.handleEvent(ebEvent);
        srs.handleEvent(sbEvent);
        srs.handleEvent(siEvent);
        srs.handleEvent(sdEvent);
        srs.handleEvent(tuEvent1);
        srs.handleEvent(tuEvent2);
        srs.handleEvent(tuEvent3);
        srs.handleEvent(tuEvent4);
        srs.handleEvent(edEvent);
        srs.handleEvent(eiEvent);
        srs.handleEvent(ebEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu1, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu2, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu3, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu4, (LocaleId)LocaleId.ENGLISH));
        TmStepsIT.testPath(outputFilePath);
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(outputFilePath, goldFilePath, "ISO-8859-1"));
    }

    @Test
    public void test_a_word_is_counted_only_once2() {
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        String outputFilePath = root.out("test_scoping_report5.txt").toString();
        String goldFilePath = root.in("gold/test_scoping_report5.txt").toString();
        Event sbEvent = new Event(EventType.START_BATCH);
        Event ebEvent = new Event(EventType.END_BATCH);
        Event siEvent = new Event(EventType.START_BATCH_ITEM);
        Event eiEvent = new Event(EventType.END_BATCH_ITEM);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        Event sdEvent = new Event(EventType.START_DOCUMENT, (IResource)sd);
        Ending ed = new Ending("ed");
        Event edEvent = new Event(EventType.END_DOCUMENT, (IResource)ed);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("Elephants cannot fly."));
        Event tuEvent1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("Elephants can't fly."));
        Event tuEvent2 = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        TextUnit tu3 = new TextUnit("tu3");
        tu3.setSource(new TextContainer("Elephants can fly."));
        Event tuEvent3 = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        TextUnit tu4 = new TextUnit("tu4");
        tu4.setSource(new TextContainer("Airplanes can fly."));
        Event tuEvent4 = new Event(EventType.TEXT_UNIT, (IResource)tu4);
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(60);
        params.setFillTarget(true);
        WordCountStep wcs = new WordCountStep();
        ScopingReportStep srs = new ScopingReportStep();
        srs.setSourceLocale(LocaleId.ENGLISH);
        srs.setTargetLocale(LocaleId.FRENCH);
        wcs.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.scopingreport.Parameters params2 = (net.sf.okapi.steps.scopingreport.Parameters)srs.getParameters();
        params2.setOutputPath(outputFilePath);
        params2.setCustomTemplateURI(root.in("golden_file_template.txt").toString());
        params2.setCountAsNonTranslatable_ExactMatch(true);
        params2.setCountAsNonTranslatable_GMXFuzzyMatch(true);
        sd.setName(params2.getCustomTemplateURI());
        wcs.handleEvent(sbEvent);
        wcs.handleEvent(siEvent);
        wcs.handleEvent(sdEvent);
        wcs.handleEvent(tuEvent1);
        wcs.handleEvent(tuEvent2);
        wcs.handleEvent(tuEvent3);
        wcs.handleEvent(tuEvent4);
        wcs.handleEvent(edEvent);
        wcs.handleEvent(eiEvent);
        wcs.handleEvent(ebEvent);
        ls.handleEvent(sbEvent);
        ls.handleEvent(siEvent);
        ls.handleEvent(sdEvent);
        ls.handleEvent(tuEvent1);
        ls.handleEvent(tuEvent2);
        ls.handleEvent(tuEvent3);
        ls.handleEvent(tuEvent4);
        ls.handleEvent(edEvent);
        ls.handleEvent(eiEvent);
        ls.handleEvent(ebEvent);
        srs.handleEvent(sbEvent);
        srs.handleEvent(siEvent);
        srs.handleEvent(sdEvent);
        srs.handleEvent(tuEvent1);
        srs.handleEvent(tuEvent2);
        srs.handleEvent(tuEvent3);
        srs.handleEvent(tuEvent4);
        srs.handleEvent(edEvent);
        srs.handleEvent(eiEvent);
        srs.handleEvent(ebEvent);
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu1, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu2, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu3, (LocaleId)LocaleId.ENGLISH));
        this.logger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu4, (LocaleId)LocaleId.ENGLISH));
        TmStepsIT.testPath(outputFilePath);
        FileCompare fc = new FileCompare();
        Assert.assertTrue((boolean)fc.compareFilesPerLines(outputFilePath, goldFilePath, "ISO-8859-1"));
    }

    private void startupFieldsTest() {
        Logger localLogger = LoggerFactory.getLogger(this.getClass());
        root = FileLocation.fromClass(this.getClass());
        Parameters rparams = new Parameters();
        rparams.setDbDirectory(dbDirectory);
        String outputFilePath = root.out("test_scoping_report6.txt").toString();
        Event sbEvent = new Event(EventType.START_BATCH);
        Event ebEvent = new Event(EventType.END_BATCH);
        Event siEvent = new Event(EventType.START_BATCH_ITEM);
        Event eiEvent = new Event(EventType.END_BATCH_ITEM);
        StartDocument sd = new StartDocument("sd");
        sd.setLocale(LocaleId.ENGLISH);
        Event sdEvent = new Event(EventType.START_DOCUMENT, (IResource)sd);
        Ending ed = new Ending("ed");
        Event edEvent = new Event(EventType.END_DOCUMENT, (IResource)ed);
        TextUnit tu1 = new TextUnit("tu1");
        tu1.setSource(new TextContainer("Elephants cannot fly."));
        Event tuEvent1 = new Event(EventType.TEXT_UNIT, (IResource)tu1);
        TextUnit tu2 = new TextUnit("tu2");
        tu2.setSource(new TextContainer("Elephants can't fly."));
        Event tuEvent2 = new Event(EventType.TEXT_UNIT, (IResource)tu2);
        TextUnit tu3 = new TextUnit("tu3");
        tu3.setSource(new TextContainer("Elephants can fly."));
        Event tuEvent3 = new Event(EventType.TEXT_UNIT, (IResource)tu3);
        TextUnit tu4 = new TextUnit("tu4");
        tu4.setSource(new TextContainer("Airplanes can fly."));
        Event tuEvent4 = new Event(EventType.TEXT_UNIT, (IResource)tu4);
        LeveragingStep ls = new LeveragingStep();
        ls.setSourceLocale(LocaleId.ENGLISH);
        ls.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.leveraging.Parameters params = ls.getParameters();
        params.setResourceParameters(rparams.toString());
        params.setResourceClassName(PensieveTMConnector.class.getName());
        params.setThreshold(60);
        params.setFillTarget(true);
        WordCountStep wcs = new WordCountStep();
        CharacterCountStep ccs = new CharacterCountStep();
        ScopingReportStep srs = new ScopingReportStep();
        srs.setSourceLocale(LocaleId.ENGLISH);
        srs.setTargetLocale(LocaleId.FRENCH);
        net.sf.okapi.steps.scopingreport.Parameters params2 = (net.sf.okapi.steps.scopingreport.Parameters)srs.getParameters();
        params2.setProjectName("test_project");
        params2.setOutputPath(outputFilePath);
        params2.setCustomTemplateURI(root.in("golden_file_template2.txt").toString());
        params2.setCountAsNonTranslatable_ExactMatch(true);
        params2.setCountAsNonTranslatable_GMXFuzzyMatch(true);
        sd.setName(params2.getCustomTemplateURI());
        wcs.handleEvent(sbEvent);
        wcs.handleEvent(siEvent);
        wcs.handleEvent(sdEvent);
        wcs.handleEvent(tuEvent1);
        wcs.handleEvent(tuEvent2);
        wcs.handleEvent(tuEvent3);
        wcs.handleEvent(tuEvent4);
        wcs.handleEvent(edEvent);
        wcs.handleEvent(eiEvent);
        wcs.handleEvent(ebEvent);
        ccs.handleEvent(sbEvent);
        ccs.handleEvent(siEvent);
        ccs.handleEvent(sdEvent);
        ccs.handleEvent(tuEvent1);
        ccs.handleEvent(tuEvent2);
        ccs.handleEvent(tuEvent3);
        ccs.handleEvent(tuEvent4);
        ccs.handleEvent(edEvent);
        ccs.handleEvent(eiEvent);
        ccs.handleEvent(ebEvent);
        ls.handleEvent(sbEvent);
        ls.handleEvent(siEvent);
        ls.handleEvent(sdEvent);
        ls.handleEvent(tuEvent1);
        ls.handleEvent(tuEvent2);
        ls.handleEvent(tuEvent3);
        ls.handleEvent(tuEvent4);
        ls.handleEvent(edEvent);
        ls.handleEvent(eiEvent);
        ls.handleEvent(ebEvent);
        srs.handleEvent(sbEvent);
        srs.handleEvent(siEvent);
        srs.handleEvent(sdEvent);
        srs.handleEvent(tuEvent1);
        srs.handleEvent(tuEvent2);
        srs.handleEvent(tuEvent3);
        srs.handleEvent(tuEvent4);
        srs.handleEvent(edEvent);
        srs.handleEvent(eiEvent);
        srs.handleEvent(ebEvent);
        localLogger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu1, (LocaleId)LocaleId.ENGLISH));
        localLogger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu2, (LocaleId)LocaleId.ENGLISH));
        localLogger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu3, (LocaleId)LocaleId.ENGLISH));
        localLogger.debug(TextUnitLogger.getTuInfo((ITextUnit)tu4, (LocaleId)LocaleId.ENGLISH));
        this.gen = srs.getReportGenerator();
    }

    private long getField(String fieldsName) {
        return Util.strToLong((String)this.gen.getField(fieldsName), (long)0L);
    }

    @Test
    public void total_counts_should_be_greater_or_equal_to_the_sum_of_categories_in_every_group() {
        this.startupFieldsTest();
        long totalWords = this.getField("PROJECT_TOTAL_WORD_COUNT");
        long totalCharacters = this.getField("PROJECT_TOTAL_CHARACTER_COUNT");
        long count = 0L;
        count += this.getField("PROJECT_EXACT_UNIQUE_ID");
        count += this.getField("PROJECT_EXACT_PREVIOUS_VERSION");
        count += this.getField("PROJECT_EXACT_LOCAL_CONTEXT");
        count += this.getField("PROJECT_EXACT_DOCUMENT_CONTEXT");
        count += this.getField("PROJECT_EXACT_STRUCTURAL");
        count += this.getField("PROJECT_EXACT");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY");
        count += this.getField("PROJECT_EXACT_REPAIRED");
        count += this.getField("PROJECT_FUZZY_PREVIOUS_VERSION");
        count += this.getField("PROJECT_FUZZY_UNIQUE_ID");
        count += this.getField("PROJECT_FUZZY");
        count += this.getField("PROJECT_FUZZY_REPAIRED");
        count += this.getField("PROJECT_PHRASE_ASSEMBLED");
        count += this.getField("PROJECT_MT");
        Assert.assertTrue((totalWords >= (count += this.getField("PROJECT_CONCORDANCE")) ? 1 : 0) != 0);
        count = 0L;
        count += this.getField("PROJECT_EXACT_UNIQUE_ID_CHARACTERS");
        count += this.getField("PROJECT_EXACT_PREVIOUS_VERSION_CHARACTERS");
        count += this.getField("PROJECT_EXACT_LOCAL_CONTEXT_CHARACTERS");
        count += this.getField("PROJECT_EXACT_DOCUMENT_CONTEXT_CHARACTERS");
        count += this.getField("PROJECT_EXACT_STRUCTURAL_CHARACTERS");
        count += this.getField("PROJECT_EXACT_CHARACTERS");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION_CHARACTERS");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID_CHARACTERS");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_CHARACTERS");
        count += this.getField("PROJECT_EXACT_REPAIRED_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_PREVIOUS_VERSION_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_UNIQUE_ID_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_REPAIRED_CHARACTERS");
        count += this.getField("PROJECT_PHRASE_ASSEMBLED_CHARACTERS");
        count += this.getField("PROJECT_MT_CHARACTERS");
        Assert.assertTrue((totalCharacters >= (count += this.getField("PROJECT_CONCORDANCE_CHARACTERS")) ? 1 : 0) != 0);
        count = 0L;
        count += this.getField("PROJECT_GMX_PROTECTED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_EXACT_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT");
        count += this.getField("PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT");
        Assert.assertTrue((totalWords >= (count += this.getField("PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT")) ? 1 : 0) != 0);
        count = 0L;
        count += this.getField("PROJECT_GMX_PROTECTED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_EXACT_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_LEVERAGED_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_REPETITION_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_FUZZY_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT");
        Assert.assertTrue((totalCharacters >= (count += this.getField("PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_CHARACTER_COUNT")) ? 1 : 0) != 0);
    }

    @Test
    public void total_counts_should_be_equal_to_the_sum_of_categories_and_nocategory() {
        this.startupFieldsTest();
        long totalWords = this.getField("PROJECT_TOTAL_WORD_COUNT");
        long totalCharacters = this.getField("PROJECT_TOTAL_CHARACTER_COUNT");
        long count = 0L;
        count += this.getField("PROJECT_EXACT_UNIQUE_ID");
        count += this.getField("PROJECT_EXACT_PREVIOUS_VERSION");
        count += this.getField("PROJECT_EXACT_LOCAL_CONTEXT");
        count += this.getField("PROJECT_EXACT_DOCUMENT_CONTEXT");
        count += this.getField("PROJECT_EXACT_STRUCTURAL");
        count += this.getField("PROJECT_EXACT");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY");
        count += this.getField("PROJECT_EXACT_REPAIRED");
        count += this.getField("PROJECT_FUZZY_PREVIOUS_VERSION");
        count += this.getField("PROJECT_FUZZY_UNIQUE_ID");
        count += this.getField("PROJECT_FUZZY");
        count += this.getField("PROJECT_FUZZY_REPAIRED");
        count += this.getField("PROJECT_PHRASE_ASSEMBLED");
        count += this.getField("PROJECT_MT");
        Assert.assertTrue((totalWords == (count += this.getField("PROJECT_CONCORDANCE")) + this.getField("PROJECT_NOCATEGORY") ? 1 : 0) != 0);
        count = 0L;
        count += this.getField("PROJECT_EXACT_UNIQUE_ID_CHARACTERS");
        count += this.getField("PROJECT_EXACT_PREVIOUS_VERSION_CHARACTERS");
        count += this.getField("PROJECT_EXACT_LOCAL_CONTEXT_CHARACTERS");
        count += this.getField("PROJECT_EXACT_DOCUMENT_CONTEXT_CHARACTERS");
        count += this.getField("PROJECT_EXACT_STRUCTURAL_CHARACTERS");
        count += this.getField("PROJECT_EXACT_CHARACTERS");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION_CHARACTERS");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID_CHARACTERS");
        count += this.getField("PROJECT_EXACT_TEXT_ONLY_CHARACTERS");
        count += this.getField("PROJECT_EXACT_REPAIRED_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_PREVIOUS_VERSION_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_UNIQUE_ID_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_CHARACTERS");
        count += this.getField("PROJECT_FUZZY_REPAIRED_CHARACTERS");
        count += this.getField("PROJECT_PHRASE_ASSEMBLED_CHARACTERS");
        count += this.getField("PROJECT_MT_CHARACTERS");
        Assert.assertTrue((totalCharacters == (count += this.getField("PROJECT_CONCORDANCE_CHARACTERS")) + this.getField("PROJECT_NOCATEGORY_CHARACTERS") ? 1 : 0) != 0);
        count = 0L;
        count += this.getField("PROJECT_GMX_PROTECTED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_EXACT_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT");
        count += this.getField("PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT");
        count += this.getField("PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT");
        Assert.assertTrue((totalWords == (count += this.getField("PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT")) + this.getField("PROJECT_GMX_NOCATEGORY") ? 1 : 0) != 0);
        count = 0L;
        count += this.getField("PROJECT_GMX_PROTECTED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_EXACT_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_LEVERAGED_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_REPETITION_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_FUZZY_MATCHED_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT");
        count += this.getField("PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT");
        Assert.assertTrue((totalCharacters == (count += this.getField("PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_CHARACTER_COUNT")) + this.getField("PROJECT_GMX_NOCATEGORY_CHARACTERS") ? 1 : 0) != 0);
    }

    @Test
    public void total_counts_should_be_equal_to_the_sum_of_translatable_and_nontranslatable() {
        this.startupFieldsTest();
        long total = this.getField("PROJECT_TOTAL_WORD_COUNT");
        Assert.assertTrue((total == this.getField("PROJECT_TRANSLATABLE_WORD_COUNT") + this.getField("PROJECT_NONTRANSLATABLE_WORD_COUNT") ? 1 : 0) != 0);
        Assert.assertTrue((total == this.getField("PROJECT_GMX_TRANSLATABLE_WORD_COUNT") + this.getField("PROJECT_GMX_NONTRANSLATABLE_WORD_COUNT") ? 1 : 0) != 0);
        total = this.getField("PROJECT_TOTAL_CHARACTER_COUNT");
        Assert.assertTrue((total == this.getField("PROJECT_TRANSLATABLE_CHARACTER_COUNT") + this.getField("PROJECT_NONTRANSLATABLE_CHARACTER_COUNT") ? 1 : 0) != 0);
        Assert.assertTrue((total == this.getField("PROJECT_GMX_TRANSLATABLE_CHARACTER_COUNT") + this.getField("PROJECT_GMX_NONTRANSLATABLE_CHARACTER_COUNT") ? 1 : 0) != 0);
    }

    private void testValue(String name, String value) {
        Assert.assertTrue((!this.gen.getField(name).contains(name) ? 1 : 0) != 0);
        Assert.assertEquals((Object)value, (Object)this.gen.getField(name));
    }

    private void testValue(String name, long value) {
        Assert.assertTrue((!this.gen.getField(name).contains(name) ? 1 : 0) != 0);
        Assert.assertEquals((long)value, (long)this.getField(name));
    }

    @Test
    public void testFields() {
        this.startupFieldsTest();
        this.testValue("PROJECT_NAME", "test_project");
        this.testValue("PROJECT_SOURCE_LOCALE", "en");
        this.testValue("PROJECT_TARGET_LOCALE", "fr");
        this.testValue("PROJECT_TOTAL_WORD_COUNT", 12L);
        this.testValue("ITEM_SOURCE_LOCALE", "en");
        this.testValue("ITEM_TARGET_LOCALE", "fr");
        this.testValue("ITEM_TOTAL_WORD_COUNT", 12L);
        this.testValue("PROJECT_GMX_PROTECTED_WORD_COUNT", 0L);
        this.testValue("PROJECT_GMX_EXACT_MATCHED_WORD_COUNT", 0L);
        this.testValue("PROJECT_GMX_LEVERAGED_MATCHED_WORD_COUNT", 3L);
        this.testValue("PROJECT_GMX_REPETITION_MATCHED_WORD_COUNT", 0L);
        this.testValue("PROJECT_GMX_FUZZY_MATCHED_WORD_COUNT", 6L);
        this.testValue("PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT", 0L);
        this.testValue("PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT", 0L);
        this.testValue("PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT", 0L);
        this.testValue("PROJECT_GMX_NONTRANSLATABLE_WORD_COUNT", 6L);
        this.testValue("PROJECT_GMX_TRANSLATABLE_WORD_COUNT", 6L);
        this.testValue("PROJECT_GMX_NOCATEGORY", 3L);
        this.testValue("ITEM_GMX_PROTECTED_WORD_COUNT", 0L);
        this.testValue("ITEM_GMX_EXACT_MATCHED_WORD_COUNT", 0L);
        this.testValue("ITEM_GMX_LEVERAGED_MATCHED_WORD_COUNT", 3L);
        this.testValue("ITEM_GMX_REPETITION_MATCHED_WORD_COUNT", 0L);
        this.testValue("ITEM_GMX_FUZZY_MATCHED_WORD_COUNT", 6L);
        this.testValue("ITEM_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_WORD_COUNT", 0L);
        this.testValue("ITEM_GMX_NUMERIC_ONLY_TEXT_UNIT_WORD_COUNT", 0L);
        this.testValue("ITEM_GMX_MEASUREMENT_ONLY_TEXT_UNIT_WORD_COUNT", 0L);
        this.testValue("ITEM_GMX_NONTRANSLATABLE_WORD_COUNT", 6L);
        this.testValue("ITEM_GMX_TRANSLATABLE_WORD_COUNT", 6L);
        this.testValue("ITEM_GMX_NOCATEGORY", 3L);
        this.testValue("PROJECT_EXACT_UNIQUE_ID", 0L);
        this.testValue("PROJECT_EXACT_PREVIOUS_VERSION", 0L);
        this.testValue("PROJECT_EXACT_LOCAL_CONTEXT", 0L);
        this.testValue("PROJECT_EXACT_DOCUMENT_CONTEXT", 0L);
        this.testValue("PROJECT_EXACT_STRUCTURAL", 0L);
        this.testValue("PROJECT_EXACT", 3L);
        this.testValue("PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION", 0L);
        this.testValue("PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID", 0L);
        this.testValue("PROJECT_EXACT_TEXT_ONLY", 0L);
        this.testValue("PROJECT_EXACT_REPAIRED", 0L);
        this.testValue("PROJECT_FUZZY_PREVIOUS_VERSION", 0L);
        this.testValue("PROJECT_FUZZY_UNIQUE_ID", 0L);
        this.testValue("PROJECT_FUZZY", 6L);
        this.testValue("PROJECT_FUZZY_REPAIRED", 0L);
        this.testValue("PROJECT_PHRASE_ASSEMBLED", 0L);
        this.testValue("PROJECT_MT", 0L);
        this.testValue("PROJECT_CONCORDANCE", 0L);
        this.testValue("PROJECT_NONTRANSLATABLE_WORD_COUNT", 3L);
        this.testValue("PROJECT_TRANSLATABLE_WORD_COUNT", 9L);
        this.testValue("PROJECT_NOCATEGORY", 3L);
        this.testValue("ITEM_EXACT_UNIQUE_ID", 0L);
        this.testValue("ITEM_EXACT_PREVIOUS_VERSION", 0L);
        this.testValue("ITEM_EXACT_LOCAL_CONTEXT", 0L);
        this.testValue("ITEM_EXACT_DOCUMENT_CONTEXT", 0L);
        this.testValue("ITEM_EXACT_STRUCTURAL", 0L);
        this.testValue("ITEM_EXACT", 3L);
        this.testValue("ITEM_EXACT_TEXT_ONLY_PREVIOUS_VERSION", 0L);
        this.testValue("ITEM_EXACT_TEXT_ONLY_UNIQUE_ID", 0L);
        this.testValue("ITEM_EXACT_TEXT_ONLY", 0L);
        this.testValue("ITEM_EXACT_REPAIRED", 0L);
        this.testValue("ITEM_FUZZY_PREVIOUS_VERSION", 0L);
        this.testValue("ITEM_FUZZY_UNIQUE_ID", 0L);
        this.testValue("ITEM_FUZZY", 6L);
        this.testValue("ITEM_FUZZY_REPAIRED", 0L);
        this.testValue("ITEM_PHRASE_ASSEMBLED", 0L);
        this.testValue("ITEM_MT", 0L);
        this.testValue("ITEM_CONCORDANCE", 0L);
        this.testValue("ITEM_NONTRANSLATABLE_WORD_COUNT", 3L);
        this.testValue("ITEM_TRANSLATABLE_WORD_COUNT", 9L);
        this.testValue("ITEM_NOCATEGORY", 3L);
        this.testValue("PROJECT_TOTAL_CHARACTER_COUNT", 65L);
        this.testValue("PROJECT_WHITESPACE_CHARACTER_COUNT", 8L);
        this.testValue("PROJECT_PUNCTUATION_CHARACTER_COUNT", 4L);
        this.testValue("PROJECT_OVERALL_CHARACTER_COUNT", 77L);
        this.testValue("ITEM_TOTAL_CHARACTER_COUNT", 65L);
        this.testValue("ITEM_WHITESPACE_CHARACTER_COUNT", 8L);
        this.testValue("ITEM_PUNCTUATION_CHARACTER_COUNT", 4L);
        this.testValue("ITEM_OVERALL_CHARACTER_COUNT", 77L);
        this.testValue("PROJECT_GMX_PROTECTED_CHARACTER_COUNT", 0L);
        this.testValue("PROJECT_GMX_EXACT_MATCHED_CHARACTER_COUNT", 0L);
        this.testValue("PROJECT_GMX_LEVERAGED_MATCHED_CHARACTER_COUNT", 18L);
        this.testValue("PROJECT_GMX_REPETITION_MATCHED_CHARACTER_COUNT", 0L);
        this.testValue("PROJECT_GMX_FUZZY_MATCHED_CHARACTER_COUNT", 32L);
        this.testValue("PROJECT_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT", 0L);
        this.testValue("PROJECT_GMX_NUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT", 0L);
        this.testValue("PROJECT_GMX_MEASUREMENT_ONLY_TEXT_UNIT_CHARACTER_COUNT", 0L);
        this.testValue("PROJECT_GMX_NONTRANSLATABLE_CHARACTER_COUNT", 32L);
        this.testValue("PROJECT_GMX_TRANSLATABLE_CHARACTER_COUNT", 33L);
        this.testValue("PROJECT_GMX_NOCATEGORY_CHARACTERS", 15L);
        this.testValue("ITEM_GMX_PROTECTED_CHARACTER_COUNT", 0L);
        this.testValue("ITEM_GMX_EXACT_MATCHED_CHARACTER_COUNT", 0L);
        this.testValue("ITEM_GMX_LEVERAGED_MATCHED_CHARACTER_COUNT", 18L);
        this.testValue("ITEM_GMX_REPETITION_MATCHED_CHARACTER_COUNT", 0L);
        this.testValue("ITEM_GMX_FUZZY_MATCHED_CHARACTER_COUNT", 32L);
        this.testValue("ITEM_GMX_ALPHANUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT", 0L);
        this.testValue("ITEM_GMX_NUMERIC_ONLY_TEXT_UNIT_CHARACTER_COUNT", 0L);
        this.testValue("ITEM_GMX_MEASUREMENT_ONLY_TEXT_UNIT_CHARACTER_COUNT", 0L);
        this.testValue("ITEM_GMX_NONTRANSLATABLE_CHARACTER_COUNT", 32L);
        this.testValue("ITEM_GMX_TRANSLATABLE_CHARACTER_COUNT", 33L);
        this.testValue("ITEM_GMX_NOCATEGORY_CHARACTERS", 15L);
        this.testValue("PROJECT_EXACT_UNIQUE_ID_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_PREVIOUS_VERSION_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_LOCAL_CONTEXT_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_DOCUMENT_CONTEXT_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_STRUCTURAL_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_CHARACTERS", 18L);
        this.testValue("PROJECT_EXACT_TEXT_ONLY_PREVIOUS_VERSION_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_TEXT_ONLY_UNIQUE_ID_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_TEXT_ONLY_CHARACTERS", 0L);
        this.testValue("PROJECT_EXACT_REPAIRED_CHARACTERS", 0L);
        this.testValue("PROJECT_FUZZY_PREVIOUS_VERSION_CHARACTERS", 0L);
        this.testValue("PROJECT_FUZZY_UNIQUE_ID_CHARACTERS", 0L);
        this.testValue("PROJECT_FUZZY_CHARACTERS", 32L);
        this.testValue("PROJECT_FUZZY_REPAIRED_CHARACTERS", 0L);
        this.testValue("PROJECT_PHRASE_ASSEMBLED_CHARACTERS", 0L);
        this.testValue("PROJECT_MT_CHARACTERS", 0L);
        this.testValue("PROJECT_CONCORDANCE_CHARACTERS", 0L);
        this.testValue("PROJECT_NONTRANSLATABLE_CHARACTER_COUNT", 18L);
        this.testValue("PROJECT_TRANSLATABLE_CHARACTER_COUNT", 47L);
        this.testValue("PROJECT_NOCATEGORY_CHARACTERS", 15L);
        this.testValue("ITEM_EXACT_UNIQUE_ID_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_PREVIOUS_VERSION_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_LOCAL_CONTEXT_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_DOCUMENT_CONTEXT_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_STRUCTURAL_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_CHARACTERS", 18L);
        this.testValue("ITEM_EXACT_TEXT_ONLY_PREVIOUS_VERSION_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_TEXT_ONLY_UNIQUE_ID_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_TEXT_ONLY_CHARACTERS", 0L);
        this.testValue("ITEM_EXACT_REPAIRED_CHARACTERS", 0L);
        this.testValue("ITEM_FUZZY_PREVIOUS_VERSION_CHARACTERS", 0L);
        this.testValue("ITEM_FUZZY_UNIQUE_ID_CHARACTERS", 0L);
        this.testValue("ITEM_FUZZY_CHARACTERS", 32L);
        this.testValue("ITEM_FUZZY_REPAIRED_CHARACTERS", 0L);
        this.testValue("ITEM_PHRASE_ASSEMBLED_CHARACTERS", 0L);
        this.testValue("ITEM_MT_CHARACTERS", 0L);
        this.testValue("ITEM_CONCORDANCE_CHARACTERS", 0L);
        this.testValue("ITEM_NONTRANSLATABLE_CHARACTER_COUNT", 18L);
        this.testValue("ITEM_TRANSLATABLE_CHARACTER_COUNT", 47L);
        this.testValue("ITEM_NOCATEGORY_CHARACTERS", 15L);
    }
}

