/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.markdown.MarkdownFilter;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripMarkdownIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_markdown";
    private static final String DIR_NAME = "/markdown/";
    private static final List<String> EXTENSIONS = Arrays.asList(".md");
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = MarkdownFilter::new;
    static final FileLocation root = FileLocation.fromClass(RoundTripMarkdownIT.class);

    public RoundTripMarkdownIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, FILTER_CONSTRUCTOR);
        this.addKnownFailingFile("test-html-block-newline.md");
        this.addKnownFailingFile("html_list_original.md");
        this.addKnownFailingFile("html_table_changed.md");
        this.addKnownFailingFile("admonitions.md");
        this.addKnownFailingFile("html_list_changed.md");
        this.addKnownFailingFile("html-table-w-empty-lines.md");
        this.addKnownFailingFile("html_table1_original.md");
    }

    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        File file = root.in("/markdown/html_table_changed.md").asFile();
        this.runTest(new BaseRoundTripIT.TestJob(CONFIG_ID, false, file, null, null, new FileComparator.EventComparator(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void markdownFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        this.realTestFiles(false, new FileComparator.EventComparator());
    }

    @Test
    public void markdownSerializedFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.realTestFiles(false, new FileComparator.EventComparator());
    }
}

