/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.its.html5.HTML5Filter;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripHtmlItsIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_itshtml5";
    private static final String DIR_NAME = "/htmlIts/";
    private static final List<String> EXTENSIONS = Arrays.asList(".html", ".html5");
    static final FileLocation root = FileLocation.fromClass(RoundTripHtmlItsIT.class);
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = HTML5Filter::new;

    public RoundTripHtmlItsIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, HTML5Filter::new);
        this.addKnownFailingFile("test01.html");
        this.addKnownFailingFile("test2.html");
    }

    @Ignore
    public void debug() throws FileNotFoundException, URISyntaxException {
        File file = root.in("/htmlIts/lqi-test1.html").asFile();
        this.runTest(new BaseRoundTripIT.TestJob(CONFIG_ID, false, file, null, null, new FileComparator.EventComparator(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void itsHtmlFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        this.realTestFiles(false, new FileComparator.EventComparator());
    }

    @Test
    public void itsHtmlFilesSerialized() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.realTestFiles(CONFIG_ID, false, new FileComparator.EventComparator());
    }
}

