/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.conversion.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.ConversionCompareIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.tmx.TmxFilter;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConvertFromTmxIT
extends ConversionCompareIT {
    private static final String CONFIG_ID = "okf_tmx";
    private static final String DIR_NAME = "/tmx/";
    private static final List<String> EXTENSIONS = Arrays.asList(".tmx");
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = TmxFilter::new;
    static final FileLocation root = FileLocation.fromClass(ConvertFromTmxIT.class);

    public ConvertFromTmxIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, FILTER_CONSTRUCTOR);
        this.addKnownFailingFile("code_id_difference.tmx");
    }

    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        File file = root.in("/tmx/code_id_difference.tmx").asFile();
        this.runTest(new BaseRoundTripIT.TestJob(CONFIG_ID, true, file, null, null, new FileComparator.EventComparatorTextUnitOnly(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void tmxFiles() throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(true, new FileComparator.EventComparatorTextUnitOnly());
    }
}

