/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.io.File;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.IPipeline;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinebuilder.XBatch;
import net.sf.okapi.common.pipelinebuilder.XBatchItem;
import net.sf.okapi.common.pipelinebuilder.XPipeline;
import net.sf.okapi.common.pipelinebuilder.XPipelineType;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.sentencealigner.SentenceAlignerStep;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PipelineBuilderTestIT {
    @Test
    public void testParallelPipeline() {
        XPipeline p5 = new XPipeline("Alignment pipeline. Source and target documents are processed by separate pipelines connected in parallel. Events from both pipelines are finalized in TestAlignerStep.", new IPipelineStep[]{new XPipeline("Parallel pipeline for parallel handling of source and target documents.", XPipelineType.PARALLEL, new IPipelineStep[]{new XPipeline("Source document translatable text extraction", new XBatch(new XBatchItem[]{new XBatchItem(new File("source.html").toURI(), "UTF-8", LocaleId.ENGLISH)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep()}), new XPipeline("Target document translatable text extraction", new XBatch(new XBatchItem[]{new XBatchItem(new File("target.doc").toURI(), "UTF-16", LocaleId.CHINA_CHINESE)}), new IPipelineStep[]{new RawDocumentToFilterEventsStep()})}), new SentenceAlignerStep(), new FilterEventsWriterStep()});
        PipelineDriver pd = new PipelineDriver();
        pd.setPipeline((IPipeline)p5);
        Assert.assertNotNull((Object)pd.getPipeline());
        Assert.assertEquals((long)3L, (long)pd.getPipeline().getSteps().size());
        p5.execute();
    }
}

