/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.observer.IObserver;
import net.sf.okapi.common.pipeline.EventObserver;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.Pipeline;
import net.sf.okapi.common.pipeline.integration.FindStringStep;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.RawDocumentWriterStep;
import net.sf.okapi.steps.common.copysource.CopySourceOnEmptyTargetStep;
import net.sf.okapi.steps.common.createtarget.CreateTargetStep;
import net.sf.okapi.steps.regexcodeextract.RegexCodeExtractionStep;
import net.sf.okapi.steps.searchandreplace.Parameters;
import net.sf.okapi.steps.searchandreplace.SearchAndReplaceStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.xsltransform.XSLTransformStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MultistepPipelineTestIT {
    private FilterConfigurationMapper fcMapper;
    private IPipelineDriver driver;
    private final LocaleId locEN = LocaleId.fromString((String)"EN");
    private final LocaleId locEUES = LocaleId.fromString((String)"eu-ES");
    private final LocaleId locFR = LocaleId.fromString((String)"FR");

    @Before
    public void setUp() throws Exception {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.its.html5.HTML5Filter");
        this.driver = new PipelineDriver();
        this.driver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
    }

    @Test
    public void xsltPipeline() throws URISyntaxException {
        String xsltPath = MultistepPipelineTestIT.class.getResource("identity.xsl").toURI().getPath();
        XSLTransformStep step1 = new XSLTransformStep();
        ((net.sf.okapi.steps.xsltransform.Parameters)step1.getParameters()).setXsltPath(xsltPath);
        XSLTransformStep step2 = new XSLTransformStep();
        ((net.sf.okapi.steps.xsltransform.Parameters)step2.getParameters()).setXsltPath(xsltPath);
        XSLTransformStep step3 = new XSLTransformStep();
        ((net.sf.okapi.steps.xsltransform.Parameters)step3.getParameters()).setXsltPath(xsltPath);
        RawDocumentWriterStep step4 = new RawDocumentWriterStep();
        this.driver.addStep((IPipelineStep)step1);
        this.driver.addStep((IPipelineStep)step2);
        this.driver.addStep((IPipelineStep)step3);
        this.driver.addStep((IPipelineStep)step4);
        try (RawDocument rawDoc = new RawDocument(this.getUri("test01.xml"), "UTF-8", this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test01.xml"), "UTF-8");
        }
        rawDoc = new RawDocument(this.getUri("test02.xml"), "UTF-8", this.locEN, this.locFR);
        try {
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test02.xml"), "UTF-8");
        }
        finally {
            rawDoc.close();
        }
        rawDoc = new RawDocument(this.getUri("test03.xml"), "UTF-8", this.locEN, this.locFR);
        try {
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test03.xml"), "UTF-8");
        }
        finally {
            rawDoc.close();
        }
        rawDoc = new RawDocument(this.getUri("test04.xml"), "UTF-8", this.locEN, this.locFR);
        try {
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test04.xml"), "UTF-8");
        }
        finally {
            rawDoc.close();
        }
        this.driver.processBatch();
        Assert.assertTrue((boolean)new File(this.getOutputUri("test01.xml")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("test02.xml")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("test03.xml")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("test04.xml")).exists());
        this.driver.clearItems();
        this.driver.clearSteps();
    }

    @Test
    public void searchAndReplacePipeline() throws URISyntaxException {
        RawDocumentToFilterEventsStep step1 = new RawDocumentToFilterEventsStep();
        SearchAndReplaceStep step2 = new SearchAndReplaceStep();
        ((Parameters)step2.getParameters()).addRule(new String[]{"true", "Okapi Framework", "Big Foot"});
        FindStringStep step3 = new FindStringStep("Big Foot");
        this.driver.addStep((IPipelineStep)step1);
        this.driver.addStep((IPipelineStep)new CreateTargetStep());
        this.driver.addStep((IPipelineStep)step2);
        this.driver.addStep((IPipelineStep)step3);
        try (RawDocument rawDoc = new RawDocument(this.getUri("okapi_intro_test.html"), "UTF-8", this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_html");
            this.driver.addBatchItem(new RawDocument[]{rawDoc});
            this.driver.processBatch();
            Assert.assertTrue((boolean)step3.isFound());
            this.driver.clearItems();
            this.driver.clearSteps();
        }
    }

    @Test
    public void backAndForthPipeline() throws URISyntaxException {
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        this.driver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        this.driver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        SearchAndReplaceStep searchReplaceStep = new SearchAndReplaceStep();
        ((Parameters)searchReplaceStep.getParameters()).addRule(new String[]{"true", "Okapi Framework", "Big Foot"});
        this.driver.addStep((IPipelineStep)new CreateTargetStep());
        this.driver.addStep((IPipelineStep)searchReplaceStep);
        FindStringStep findStep = new FindStringStep("Big Foot");
        this.driver.addStep((IPipelineStep)findStep);
        try (RawDocument rawDoc = new RawDocument(this.getUri("okapi_intro_test.html"), "UTF-8", this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_html");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("okapi_intro_test.html"), "UTF-8");
            this.driver.processBatch();
            Assert.assertTrue((boolean)findStep.isFound());
            this.driver.clearItems();
            this.driver.clearSteps();
        }
    }

    @Test
    public void copySourceToTargetPipeline() throws URISyntaxException {
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        CreateTargetStep copySourceToTargetStep = new CreateTargetStep();
        copySourceToTargetStep.setTargetLocale(this.locEUES);
        this.driver.addStep((IPipelineStep)copySourceToTargetStep);
        this.driver.addStep((IPipelineStep)new FilterEventsWriterStep());
        try (RawDocument rawDoc = new RawDocument(this.getUri("Test01.properties"), "UTF-8", this.locEN, this.locEUES);){
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test01.properties"), "UTF-8");
        }
        rawDoc = new RawDocument(this.getUri("Test02.properties"), "UTF-8", this.locEN, this.locEUES);
        try {
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test02.properties"), "UTF-8");
        }
        finally {
            rawDoc.close();
        }
        rawDoc = new RawDocument(this.getUri("Test03.properties"), "UTF-8", this.locEN, this.locEUES);
        try {
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test03.properties"), "UTF-8");
        }
        finally {
            rawDoc.close();
        }
        this.driver.processBatch();
        Assert.assertTrue((boolean)new File(this.getOutputUri("Test01.properties")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("Test02.propertiesl")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("Test03.properties")).exists());
        this.driver.clearItems();
        this.driver.clearSteps();
    }

    @Test
    public void segmentationPipeline() throws URISyntaxException {
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        SegmentationStep ss = new SegmentationStep();
        net.sf.okapi.steps.segmentation.Parameters sp = ss.getParameters();
        sp.setSourceSrxPath(new File(this.getUri("test.srx")).getAbsolutePath());
        sp.setSegmentSource(true);
        this.driver.addStep((IPipelineStep)ss);
        this.driver.addStep((IPipelineStep)new FilterEventsWriterStep());
        try (RawDocument rawDoc = new RawDocument(this.getUri("Test01.properties"), "UTF-8", this.locEN);){
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test01.properties"), "UTF-8");
            this.driver.processBatch();
            Assert.assertTrue((boolean)new File(this.getOutputUri("Test01.properties")).exists());
            this.driver.clearItems();
            this.driver.clearSteps();
        }
    }

    private URI getUri(String fileName) throws URISyntaxException {
        URL url = MultistepPipelineTestIT.class.getResource("/" + fileName);
        return url.toURI();
    }

    @Test
    public void testRegexCodeGenStepWithMustacheHtml() {
        RawDocumentToFilterEventsStep r2eStep = new RawDocumentToFilterEventsStep();
        this.driver.addStep((IPipelineStep)r2eStep);
        RegexCodeExtractionStep codeGenStep = new RegexCodeExtractionStep();
        codeGenStep.getParameters().setCodeFinderRules("#1\ncount.i=1\nrule0=\\{\\{.+?}}\n");
        this.driver.addStep((IPipelineStep)codeGenStep);
        EventObserver eo = new EventObserver();
        Pipeline pipeline = (Pipeline)this.driver.getPipeline();
        pipeline.addObserver((IObserver)eo);
        String testDoc = "<html><body><p>\n{{#approved}}\nYour loan application has been <b>approved</b>.\n{{/approved}}\n{{^approved}}\nUnfortunately your loan application was <i>not</i> approved.\n{{^approved}}\n{{! Encoding test: &lt; &amp; }}\n</p></body></html>";
        try (RawDocument rawDoc = new RawDocument((CharSequence)testDoc, this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_html");
            this.driver.addBatchItem(new RawDocument[]{rawDoc});
            this.driver.processBatch();
        }
        List events = eo.getResult();
        events.stream().forEach(Util::printEvent);
        Assert.assertEquals((long)9L, (long)events.size());
        Optional<Event> firstTuEvOp = events.stream().filter(e -> e.isTextUnit()).findFirst();
        Assert.assertTrue((boolean)firstTuEvOp.isPresent());
        Event firstTuEv = firstTuEvOp.get();
        ITextUnit firstTu = firstTuEv.getTextUnit();
        List codes = firstTu.getSource().getFirstContent().getCodes();
        Assert.assertNotNull((Object)codes);
        Assert.assertEquals((long)9L, (long)codes.size());
        Assert.assertEquals((Object)"{{! Encoding test: &lt; &amp; }}", (Object)((Code)codes.get(8)).getData());
    }

    @Test
    public void testMustacheHtmlRoundTrip() {
        RawDocumentToFilterEventsStep r2eStep = new RawDocumentToFilterEventsStep();
        this.driver.addStep((IPipelineStep)r2eStep);
        RegexCodeExtractionStep codeGenStep = new RegexCodeExtractionStep();
        codeGenStep.getParameters().setCodeFinderRules("#1\ncount.i=1\nrule0=\\<% .*? %>\n");
        this.driver.addStep((IPipelineStep)codeGenStep);
        this.driver.addStep((IPipelineStep)new CopySourceOnEmptyTargetStep());
        FilterEventsToRawDocumentStep e2rd = new FilterEventsToRawDocumentStep();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        e2rd.setOutputStream((OutputStream)baos);
        this.driver.addStep((IPipelineStep)e2rd);
        String testDoc = "<html><body><p>\n{{#approved}}\nYour loan application has been <b>approved</b>.\n{{/approved}}\n{{^approved}}\nUnfortunately your loan application was <i>not</i> approved.\n{{^approved}}\n{{! Encoding test: &lt; &amp; }}\n</p></body></html>";
        try (RawDocument rawDoc = new RawDocument((CharSequence)testDoc, this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_html");
            this.driver.addBatchItem(new RawDocument[]{rawDoc});
            this.driver.processBatch();
        }
        String rebuiltDoc = baos.toString(StandardCharsets.UTF_16BE);
        Assert.assertEquals((Object)testDoc.replaceAll("\\s+", ""), (Object)rebuiltDoc.replaceAll("\ufeff|\\s+", ""));
    }

    @Test
    public void testHtmlSimpleRoundTrip() {
        RawDocumentToFilterEventsStep step1 = new RawDocumentToFilterEventsStep();
        this.driver.addStep((IPipelineStep)step1);
        this.driver.addStep((IPipelineStep)new CopySourceOnEmptyTargetStep());
        FilterEventsToRawDocumentStep step3 = new FilterEventsToRawDocumentStep();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        step3.setOutputStream((OutputStream)baos);
        this.driver.addStep((IPipelineStep)step3);
        String jspDoc = "\ufeff<!DOCTYPE html>\n<html><head></head><body><p>Hello, World!</p>\n</body></html>";
        try (RawDocument rawDoc = new RawDocument((CharSequence)jspDoc, this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_itshtml5");
            this.driver.addBatchItem(new RawDocument[]{rawDoc});
            this.driver.processBatch();
        }
        String rebuiltJspDoc = baos.toString(StandardCharsets.UTF_16BE);
        Assert.assertEquals((Object)StringUtil.collapseWhitespace((String)jspDoc), (Object)StringUtil.collapseWhitespace((String)rebuiltJspDoc));
    }

    private URI getOutputUri(String fileName) {
        File f = new File(Util.getTempDirectory() + "/fileName");
        f.deleteOnExit();
        return f.toURI();
    }
}

