/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.io.UnsupportedEncodingException;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.integration.PipelineTestUtil;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterRoundtripTestIT {
    private IPipelineDriver driver;
    private IFilterConfigurationMapper fcMapper;
    private final LocaleId locEN = LocaleId.fromString((String)"EN");
    private final LocaleId locES = LocaleId.fromString((String)"ES");
    private final LocaleId locFR = LocaleId.fromString((String)"FR");
    private FileLocation root;

    @Before
    public void setUp() {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.driver = new PipelineDriver();
        this.driver.setFilterConfigurationMapper(this.fcMapper);
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        this.driver.addStep((IPipelineStep)new FilterEventsWriterStep());
        this.root = FileLocation.fromClass(this.getClass());
    }

    @Test
    public void runPipelineFromString() {
        this.driver.clearItems();
        try (RawDocument rd = new RawDocument((CharSequence)"<p>Before <input type=\"radio\" name=\"FavouriteFare\" value=\"spam\" checked=\"checked\"/> after.</p>", this.locEN, this.locES);
             RawDocument rawDoc = new RawDocument(this.root.out("genericOutput.txt").asUri(), "UTF-8", this.locES);){
            rd.setFilterConfigId("okf_html");
            this.driver.addBatchItem(rd, this.root.out("genericOutput.txt").asUri(), "UTF-8");
            this.driver.processBatch();
            Assert.assertEquals((Object)"spam", (Object)PipelineTestUtil.getFirstTUSource(rawDoc));
        }
    }

    @Test
    public void runPipelineFromStream() {
        this.driver.clearItems();
        try (RawDocument rd = new RawDocument((CharSequence)"\nX\n\nY\n", this.locEN, this.locFR);
             RawDocument rawDoc = new RawDocument(this.root.out("genericOutput.txt").asUri(), "UTF-8", this.locFR);){
            rd.setFilterConfigId("okf_html");
            this.driver.addBatchItem(rd, this.root.out("genericOutput.txt").asUri(), "UTF-8");
            this.driver.processBatch();
            Assert.assertEquals((Object)"X Y", (Object)PipelineTestUtil.getFirstTUSource(rawDoc));
        }
    }

    @Test
    public void runPipelineTwice() throws UnsupportedEncodingException {
        String snippet = "<b>TEST ME</b>";
        this.driver.clearItems();
        try (RawDocument rd = new RawDocument((CharSequence)snippet, this.locEN, this.locES);){
            rd.setFilterConfigId("okf_html");
            this.driver.addBatchItem(rd, this.root.out("output1.html").asUri(), "UTF-8");
            this.driver.processBatch();
        }
        this.driver.clearItems();
        rd = new RawDocument(this.root.out("output1.html").asUri(), "UTF-8", this.locES, this.locEN);
        try {
            rd.setFilterConfigId("okf_html");
            this.driver.addBatchItem(rd, this.root.out("output2.html").asUri(), "UTF-8");
            this.driver.processBatch();
        }
        finally {
            rd.close();
        }
        rd = new RawDocument(this.root.out("output2.html").asUri(), "UTF-8", this.locES);
        try {
            Assert.assertEquals((Object)snippet, (Object)PipelineTestUtil.getFirstTUSource(rd));
        }
        finally {
            rd.close();
        }
    }
}

