/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filters.ThreadSafeFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.integration.IntegrationtestUtils;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.archive.ArchiveFilter;
import net.sf.okapi.filters.doxygen.DoxygenFilter;
import net.sf.okapi.filters.dtd.DTDFilter;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.icml.ICMLFilter;
import net.sf.okapi.filters.idml.IDMLFilter;
import net.sf.okapi.filters.its.html5.HTML5Filter;
import net.sf.okapi.filters.json.JSONFilter;
import net.sf.okapi.filters.markdown.MarkdownFilter;
import net.sf.okapi.filters.messageformat.MessageFormatFilter;
import net.sf.okapi.filters.mif.MIFFilter;
import net.sf.okapi.filters.openoffice.ODFFilter;
import net.sf.okapi.filters.openoffice.OpenOfficeFilter;
import net.sf.okapi.filters.openxml.OpenXMLFilter;
import net.sf.okapi.filters.plaintext.PlainTextFilter;
import net.sf.okapi.filters.po.POFilter;
import net.sf.okapi.filters.properties.PropertiesFilter;
import net.sf.okapi.filters.regex.RegexFilter;
import net.sf.okapi.filters.table.TableFilter;
import net.sf.okapi.filters.tex.TEXFilter;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.filters.transtable.TransTableFilter;
import net.sf.okapi.filters.ts.TsFilter;
import net.sf.okapi.filters.ttml.TTMLFilter;
import net.sf.okapi.filters.ttx.TTXFilter;
import net.sf.okapi.filters.txml.TXMLFilter;
import net.sf.okapi.filters.vtt.VTTFilter;
import net.sf.okapi.filters.wiki.WikiFilter;
import net.sf.okapi.filters.xini.XINIFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.filters.xliff2.XLIFF2Filter;
import net.sf.okapi.filters.xml.XMLFilter;
import net.sf.okapi.filters.xmlstream.XmlStreamFilter;
import net.sf.okapi.filters.yaml.YamlFilter;
import net.sf.okapi.lib.merge.step.OriginalDocumentXliffMergerStep;
import net.sf.okapi.lib.merge.step.Parameters;
import net.sf.okapi.lib.segmentation.SRXSegmenter;
import net.sf.okapi.lib.serialization.filter.ProtoFilter;
import net.sf.okapi.lib.serialization.step.OriginalDocumentProtoMergerStep;
import net.sf.okapi.lib.serialization.writer.ProtoBufferWriter;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.codesimplifier.PostSegmentationCodeSimplifierStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrectionStep;

public final class RoundTripUtils {
    private static final String sourceSrx = Objects.requireNonNull(StreamUtil.streamUtf8AsString((InputStream)SRXSegmenter.class.getClassLoader().getResourceAsStream("net/sf/okapi/lib/segmentation/defaultSegmentation.srx")));
    private static final String targetSrx = Objects.requireNonNull(StreamUtil.streamUtf8AsString((InputStream)SRXSegmenter.class.getClassLoader().getResourceAsStream("net/sf/okapi/lib/segmentation/defaultSegmentation.srx")));
    private static final IFilterConfigurationMapper mapper = new ThreadSafeFilterConfigurationMapper(RoundTripUtils::loadDefaultConfigs);

    public static IFilterConfigurationMapper extract(LocaleId source, LocaleId target, String original, String outputPath, String configId, String customConfigPath, boolean serializedOutput) throws URISyntaxException, FileNotFoundException {
        return RoundTripUtils.extract(source, target, original, outputPath, configId, customConfigPath, serializedOutput, false);
    }

    private static Map<String, FilterConfiguration> loadDefaultConfigs() {
        ThreadSafeFilterConfigurationMapper.ConfigBuilder builder = new ThreadSafeFilterConfigurationMapper.ConfigBuilder();
        builder.addConfigurations(OpenXMLFilter.class);
        builder.addConfigurations(HtmlFilter.class);
        builder.addConfigurations(HTML5Filter.class);
        builder.addConfigurations(JSONFilter.class);
        builder.addConfigurations(XmlStreamFilter.class);
        builder.addConfigurations(PlainTextFilter.class);
        builder.addConfigurations(DTDFilter.class);
        builder.addConfigurations(XLIFFFilter.class);
        builder.addConfigurations(OpenOfficeFilter.class);
        builder.addConfigurations(ODFFilter.class);
        builder.addConfigurations(PropertiesFilter.class);
        builder.addConfigurations(POFilter.class);
        builder.addConfigurations(RegexFilter.class);
        builder.addConfigurations(TsFilter.class);
        builder.addConfigurations(TableFilter.class);
        builder.addConfigurations(XMLFilter.class);
        builder.addConfigurations(IDMLFilter.class);
        builder.addConfigurations(ArchiveFilter.class);
        builder.addConfigurations(YamlFilter.class);
        builder.addConfigurations(MIFFilter.class);
        builder.addConfigurations(TXMLFilter.class);
        builder.addConfigurations(DoxygenFilter.class);
        builder.addConfigurations(WikiFilter.class);
        builder.addConfigurations(ICMLFilter.class);
        builder.addConfigurations(XLIFF2Filter.class);
        builder.addConfigurations(MarkdownFilter.class);
        builder.addConfigurations(TEXFilter.class);
        builder.addConfigurations(TransTableFilter.class);
        builder.addConfigurations(TmxFilter.class);
        builder.addConfigurations(XINIFilter.class);
        builder.addConfigurations(TTXFilter.class);
        builder.addConfigurations(MessageFormatFilter.class);
        builder.addConfigurations(VTTFilter.class);
        builder.addConfigurations(TTMLFilter.class);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFilterConfigurationMapper extract(LocaleId source, LocaleId target, String originalPath, String outputPath, String configId, String customConfigPath, boolean serializedOutput, boolean simplify) throws URISyntaxException, FileNotFoundException {
        LinkedList<Object> steps = new LinkedList<Object>();
        RoundTripUtils.addCustomConfigs(customConfigPath, configId);
        try (RawDocument originalDoc = new RawDocument(Util.toURI((String)originalPath), StandardCharsets.UTF_8.name(), source, target);
             IFilter filter = mapper.createFilter(configId);){
            Object writer;
            steps.addAll(RoundTripUtils.createInitialPipeline(target, configId, simplify));
            if (serializedOutput) {
                writer = new ProtoBufferWriter();
                try {
                    FilterEventsWriterStep iFilter = new FilterEventsWriterStep();
                    iFilter.setFilterWriter((IFilterWriter)writer);
                    net.sf.okapi.lib.serialization.filter.Parameters params = writer.getParameters();
                    params.setCopySource(true);
                    iFilter.setDocumentRoots(Util.getDirectoryName((String)originalPath));
                    iFilter.setOutputURI(new File(outputPath).toURI());
                    iFilter.setOutputEncoding(StandardCharsets.UTF_8.name());
                    iFilter.setFilterConfigurationMapper(mapper);
                    iFilter.setLastOutputStep(true);
                    steps.add(iFilter);
                }
                finally {
                    writer.close();
                }
            }
            writer = new XLIFFWriter();
            try {
                FilterEventsWriterStep filterEventsWriterStep = new FilterEventsWriterStep();
                filterEventsWriterStep.setFilterWriter((IFilterWriter)writer);
                XLIFFWriterParameters xliffParams = writer.getParameters();
                xliffParams.setPlaceholderMode(false);
                xliffParams.setIncludeAltTrans(true);
                xliffParams.setEscapeGt(true);
                xliffParams.setIncludeCodeAttrs(true);
                xliffParams.setCopySource(true);
                xliffParams.setIncludeIts(true);
                xliffParams.setIncludeNoTranslate(true);
                xliffParams.setToolId("okapi");
                xliffParams.setToolName("okapi-tests");
                xliffParams.setToolCompany("okapi");
                xliffParams.setToolVersion("M29");
                filterEventsWriterStep.setOutputURI(new File(outputPath).toURI());
                filterEventsWriterStep.setOutputEncoding(StandardCharsets.UTF_8.name());
                filterEventsWriterStep.setDocumentRoots(Util.getDirectoryName((String)originalPath));
                filterEventsWriterStep.setFilterConfigurationMapper(mapper);
                filterEventsWriterStep.setLastOutputStep(true);
                steps.add(filterEventsWriterStep);
            }
            finally {
                writer.close();
            }
            for (IPipelineStep iPipelineStep : steps) {
                iPipelineStep.setSourceLocale(source);
                iPipelineStep.setTargetLocale(target);
                iPipelineStep.handleEvent(Event.createStartBatchEvent());
                iPipelineStep.handleEvent(Event.createStartBatchItemEvent());
            }
            ArrayList stepsAsFunctions = new ArrayList(steps);
            try (IFilter iFilter = filter;){
                filter.open(originalDoc);
                filter.stream().flatMap(e -> (Stream)IPipelineStep.runPipelineSteps((List)stepsAsFunctions, Stream.of(e))).count();
            }
            finally {
                steps.forEach(IPipelineStep::close);
            }
        }
        catch (Exception e2) {
            throw new OkapiException((Throwable)e2);
        }
        finally {
            steps.forEach(IPipelineStep::close);
        }
        return mapper;
    }

    private static void addCustomConfigs(String customConfigPath, String configId) throws FileNotFoundException {
        if (customConfigPath != null) {
            File cp = new File(customConfigPath);
            Collection<File> primaryConfigs = IntegrationtestUtils.getConfigFiles(cp);
            for (File c : primaryConfigs) {
                mapper.addCustomConfiguration(configId, StreamUtil.streamUtf8AsString((InputStream)new FileInputStream(c)));
            }
            File secondaryConfig = IntegrationtestUtils.getSecondaryConfigFile(cp, configId);
            if (secondaryConfig != null) {
                mapper.addCustomConfiguration(Util.getFilename((String)secondaryConfig.getName(), (boolean)false), StreamUtil.streamUtf8AsString((InputStream)new FileInputStream(secondaryConfig)));
            }
        }
    }

    private static List<IPipelineStep> createInitialPipeline(LocaleId target, String configId, boolean simplify) {
        LinkedList<IPipelineStep> pipeline = new LinkedList<IPipelineStep>();
        SegmentationStep ss = new SegmentationStep();
        LinkedList<LocaleId> tl = new LinkedList<LocaleId>();
        tl.add(target);
        ss.setTargetLocales(tl);
        net.sf.okapi.steps.segmentation.Parameters params = ss.getParameters();
        params.setSegmentSource(true);
        params.setSegmentTarget(true);
        params.setDoNotSegmentIfHasTarget(true);
        params.setSourceSrx(sourceSrx);
        params.setTargetSrx(targetSrx);
        ss.setParameters((IParameters)params);
        pipeline.add((IPipelineStep)ss);
        if (simplify) {
            net.sf.okapi.steps.common.codesimplifier.Parameters p = new net.sf.okapi.steps.common.codesimplifier.Parameters();
            ISimplifierRulesParameters fp = (ISimplifierRulesParameters)RoundTripUtils.mapper.getConfiguration((String)configId).parameters;
            if (fp != null && null != fp.getSimplifierRules()) {
                p.setRules(fp.getSimplifierRules());
            }
            PostSegmentationCodeSimplifierStep simplifier = new PostSegmentationCodeSimplifierStep();
            simplifier.setParameters((IParameters)p);
            pipeline.add((IPipelineStep)simplifier);
        }
        return pipeline;
    }

    public static void merge(LocaleId source, LocaleId target, String originalPath, String extractedPath, String outputPath, String configId, boolean serializedOutput) throws URISyntaxException {
        block21: {
            try (RawDocument originalDoc = new RawDocument(Util.toURI((String)originalPath), StandardCharsets.UTF_8.name(), source, target);
                 RawDocument extractedDoc = new RawDocument(Util.toURI((String)extractedPath), StandardCharsets.UTF_8.name(), source, target);){
                originalDoc.setFilterConfigId(configId);
                LinkedList<IPipelineStep> steps = new LinkedList<IPipelineStep>();
                steps.add((IPipelineStep)new WhitespaceCorrectionStep());
                if (serializedOutput) {
                    try (ProtoFilter f = new ProtoFilter();){
                        OriginalDocumentProtoMergerStep originalDocumentProtoMergerStep = new OriginalDocumentProtoMergerStep();
                        originalDocumentProtoMergerStep.getSkelMergerWriter().setOutput(outputPath);
                        originalDocumentProtoMergerStep.setFilterConfigurationMapper(mapper);
                        originalDocumentProtoMergerStep.setOutputEncoding(StandardCharsets.UTF_8.name());
                        originalDocumentProtoMergerStep.setSecondInput(originalDoc);
                        net.sf.okapi.lib.serialization.step.Parameters params = new net.sf.okapi.lib.serialization.step.Parameters();
                        params.setPreserveWhiteSpaceByDefault(true);
                        steps.add((IPipelineStep)originalDocumentProtoMergerStep);
                        f.open(extractedDoc);
                        RoundTripUtils.mergePipeline((IFilter)f, steps, source, target);
                        break block21;
                    }
                }
                try (XLIFFFilter f = new XLIFFFilter();){
                    OriginalDocumentXliffMergerStep originalDocumentXliffMergerStep = new OriginalDocumentXliffMergerStep();
                    Parameters parameters = new Parameters();
                    parameters.setPreserveWhiteSpaceByDefault(true);
                    originalDocumentXliffMergerStep.getSkelMergerWriter().setOutput(outputPath);
                    originalDocumentXliffMergerStep.setParameters((IParameters)parameters);
                    originalDocumentXliffMergerStep.setFilterConfigurationMapper(mapper);
                    originalDocumentXliffMergerStep.setOutputEncoding(StandardCharsets.UTF_8.name());
                    originalDocumentXliffMergerStep.setSecondInput(originalDoc);
                    steps.add((IPipelineStep)originalDocumentXliffMergerStep);
                    net.sf.okapi.filters.xliff.Parameters xliffParams = new net.sf.okapi.filters.xliff.Parameters();
                    xliffParams.setPreserveSpaceByDefault(true);
                    f.setParameters((IParameters)xliffParams);
                    f.open(extractedDoc);
                    RoundTripUtils.mergePipeline((IFilter)f, steps, source, target);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mergePipeline(IFilter filter, List<IPipelineStep> steps, LocaleId source, LocaleId target) {
        for (IPipelineStep s : steps) {
            s.setSourceLocale(source);
            s.setTargetLocale(target);
            s.handleEvent(Event.createStartBatchEvent());
            s.handleEvent(Event.createStartBatchItemEvent());
        }
        ArrayList<IPipelineStep> stepsAsFunctions = new ArrayList<IPipelineStep>(steps);
        try (IFilter iFilter = filter;){
            long l = filter.stream().flatMap(e -> (Stream)IPipelineStep.runPipelineSteps((List)stepsAsFunctions, Stream.of(e))).count();
        }
        finally {
            steps.forEach(IPipelineStep::close);
        }
    }

    public static boolean compareEvents(List<Event> actual, List<Event> expected, boolean includeSkeleton, boolean ignoreSkelWhitespace, boolean ignoreFragmentWhitespace, boolean ignoreSegmentation) {
        return FilterTestDriver.compareEvents(actual, expected, (boolean)includeSkeleton, (boolean)ignoreSkelWhitespace, (boolean)ignoreFragmentWhitespace, (boolean)ignoreSegmentation);
    }

    public static boolean compareTextUnits(List<ITextUnit> actual, List<ITextUnit> expected, boolean ignoreFragmentWhitespace) {
        return FilterTestDriver.compareTextUnits(actual, expected, (boolean)ignoreFragmentWhitespace);
    }
}

