/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;

public final class IntegrationtestUtils {
    public static final FileLocation ROOT = FileLocation.fromClass(IntegrationtestUtils.class);

    public static Collection<File> getTestFiles(File dir, List<String> extensions) {
        FilenameFilter filter = (dir1, name) -> {
            for (String e : extensions) {
                if (!name.endsWith(e)) continue;
                return true;
            }
            return false;
        };
        return FileUtil.getFilteredFiles((File)dir, (FilenameFilter)filter, (boolean)true);
    }

    public static Collection<File> getTestFilesNoRecurse(File dir, List<String> extensions) {
        FilenameFilter filter = (dir1, name) -> {
            for (String e : extensions) {
                if (!name.endsWith(e)) continue;
                return true;
            }
            return false;
        };
        return FileUtil.getFilteredFiles((File)dir, (FilenameFilter)filter, (boolean)false);
    }

    public static Collection<File> getSubDirsNoRecurse(File dir) {
        FilenameFilter filter = (d, n) -> new File(d, n).isDirectory();
        return FileUtil.getFilteredFiles((File)dir, (FilenameFilter)filter, (boolean)false);
    }

    public static Collection<File> getSubDirs(File dir) {
        FilenameFilter filter = (d, n) -> new File(d, n).isDirectory();
        return FileUtil.getFilteredFiles((File)dir, (FilenameFilter)filter, (boolean)true);
    }

    public static File getSecondaryConfigFile(File dir, String primaryConfigName) {
        List<String> extensions = Arrays.asList(".secondary.fprm", ".secondary.its");
        Collection<File> secondaries = IntegrationtestUtils.getTestFilesNoRecurse(dir, extensions);
        Iterator<File> iterator = secondaries.iterator();
        if (iterator.hasNext()) {
            File file = iterator.next();
            String p = Util.getFilename((String)primaryConfigName, (boolean)false);
            return file;
        }
        return null;
    }

    public static Collection<File> getConfigFiles(File dir) {
        List<String> extensions = Arrays.asList(".fprm", ".its");
        LinkedList<File> primaries = new LinkedList<File>();
        for (File f : IntegrationtestUtils.getTestFilesNoRecurse(dir, extensions)) {
            String p = Util.getFilename((String)f.getName(), (boolean)true);
            if (p.endsWith(".secondary.fprm") || p.endsWith(".secondary.its")) continue;
            primaries.add(f);
        }
        return primaries;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File asFile(String rootPath, String fileName) throws URISyntaxException, IOException {
        try (JarFile jarFile = new JarFile(rootPath);){
            JarEntry entry;
            String name2;
            Enumeration<JarEntry> entries = jarFile.entries();
            do {
                if (!entries.hasMoreElements()) return null;
            } while (!fileName.equals(name2 = (entry = entries.nextElement()).getName()));
            jarFile.close();
            File file = new File(Util.buildPath((String[])new String[]{rootPath, name2}));
            return file;
        }
        catch (IOException | SecurityException e) {
            String[] stringArray = Objects.requireNonNull(new File(rootPath).list((dir, name) -> fileName.equals(name)));
            int n = stringArray.length;
            int n2 = 0;
            if (n2 >= n) return null;
            String fname = stringArray[n2];
            String fpath = Util.buildPath((String[])new String[]{rootPath, fname});
            return new File(fpath);
        }
    }

    public static ArrayList<Event> getEvents(IFilter filter, RawDocument rd, IParameters parameters) {
        ArrayList<Event> list = new ArrayList<Event>();
        try (IFilter iFilter = filter;
             RawDocument rawDocument = rd;){
            if (parameters != null) {
                filter.setParameters(parameters);
            }
            filter.open(rd);
            while (filter.hasNext()) {
                list.add(filter.next());
            }
        }
        return list;
    }

    public static ArrayList<Event> getNonTextUnitEvents(IFilter filter, RawDocument rd, IParameters parameters) {
        ArrayList<Event> list = new ArrayList<Event>();
        try (IFilter iFilter = filter;
             RawDocument rawDocument = rd;){
            if (parameters != null) {
                filter.setParameters(parameters);
            }
            filter.open(rd);
            while (filter.hasNext()) {
                Event e = filter.next();
                if (e.isTextUnit()) continue;
                list.add(e);
            }
        }
        return list;
    }

    public static ArrayList<ITextUnit> getTextUnitEvents(IFilter filter, RawDocument rd, IParameters parameters) {
        ArrayList<ITextUnit> list = new ArrayList<ITextUnit>();
        try (IFilter iFilter = filter;
             RawDocument rawDocument = rd;){
            if (parameters != null) {
                filter.setParameters(parameters);
            }
            filter.open(rd);
            while (filter.hasNext()) {
                Event e = filter.next();
                if (!e.isTextUnit()) continue;
                list.add(e.getTextUnit());
            }
        }
        return list;
    }

    public static ArrayList<Event> getEvents(String snippet, IFilter filter, IParameters parameters) {
        ArrayList<Event> list = new ArrayList<Event>();
        if (parameters != null) {
            filter.setParameters(parameters);
        }
        try (IFilter iFilter = filter;
             RawDocument rawDoc = new RawDocument((CharSequence)snippet, LocaleId.ENGLISH);){
            filter.open(rawDoc);
            while (filter.hasNext()) {
                Event event = filter.next();
                list.add(event);
            }
        }
        return list;
    }

    public static boolean deleteDirRecursive(String path) {
        File d = new File(path);
        if (d.isDirectory()) {
            String[] children = d.list();
            assert (children != null);
            for (String child : children) {
                boolean success = IntegrationtestUtils.deleteDirRecursive(d.getAbsolutePath() + File.separator + child);
                if (success) continue;
                return false;
            }
        }
        if (d.exists()) {
            return d.delete();
        }
        return true;
    }
}

