/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.IComparator;
import net.sf.okapi.common.integration.IntegrationtestUtils;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRoundTripIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final String defaultConfigId;
    final boolean parallel;
    final String dirName;
    List<String> extensions;
    final LocaleId defaultTargetLocale;
    final Set<String> knownFailingFiles = new HashSet<String>();
    final String xliffExtractedExtension;
    final Supplier<IFilter> filterConstructor;
    boolean serializedOutput = false;
    String serializedExtractedExtension = ".json";
    @Rule
    public ErrorCollector errCol = new ErrorCollector();

    public BaseRoundTripIT(boolean parallel, String configId, String dirName, List<String> extensions, Supplier<IFilter> filterConstructor) {
        this(parallel, configId, dirName, extensions, LocaleId.FRENCH, filterConstructor);
    }

    public BaseRoundTripIT(boolean parallel, String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale, Supplier<IFilter> filterConstructor) {
        this.parallel = parallel;
        this.defaultConfigId = configId;
        this.dirName = dirName;
        this.extensions = extensions;
        this.defaultTargetLocale = defaultTargetLocale;
        this.xliffExtractedExtension = configId.startsWith("okf_xliff") ? ".xliff_extracted" : ".xliff";
        this.filterConstructor = filterConstructor;
        this.serializedOutput = false;
        this.serializedExtractedExtension = ".ser";
    }

    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public boolean isSerializedOutput() {
        return this.serializedOutput;
    }

    public void setSerializedOutput(boolean serializedOutput) {
        this.serializedOutput = serializedOutput;
    }

    public void addKnownFailingFile(String fileName) {
        this.knownFailingFiles.add(fileName);
    }

    public void realTestFiles(boolean detectLocales, IComparator comparator) throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(this.defaultConfigId, detectLocales, comparator);
    }

    public void realTestFiles(String cfgId, boolean detectLocales, IComparator comparator) throws FileNotFoundException, URISyntaxException {
        ArrayList<TestJob> testJobs = new ArrayList<TestJob>();
        File dir = IntegrationtestUtils.ROOT.in(this.dirName).asFile();
        for (File file : IntegrationtestUtils.getTestFilesNoRecurse(dir, this.extensions)) {
            testJobs.add(new TestJob(cfgId, detectLocales, file, null, null, comparator, this.filterConstructor));
        }
        if (this.parallel) {
            testJobs.parallelStream().forEach(this::runTest);
        } else {
            testJobs.forEach(this::runTest);
        }
        testJobs.clear();
        for (File subDir : IntegrationtestUtils.getSubDirs(dir)) {
            for (File file : IntegrationtestUtils.getTestFilesNoRecurse(subDir, this.extensions)) {
                Collection<File> configs = IntegrationtestUtils.getConfigFiles(subDir);
                if (configs.isEmpty()) {
                    testJobs.add(new TestJob(cfgId, detectLocales, file, subDir, null, comparator, this.filterConstructor));
                    continue;
                }
                for (File c : configs) {
                    String configId = Util.getFilename((String)c.getAbsolutePath(), (boolean)false);
                    String customConfigPath = c.getParent();
                    testJobs.add(new TestJob(configId, detectLocales, file, subDir, customConfigPath, comparator, this.filterConstructor));
                }
            }
        }
        if (this.parallel) {
            testJobs.parallelStream().forEach(this::runTest);
        } else {
            testJobs.forEach(this::runTest);
        }
    }

    protected abstract void runTest(TestJob var1);

    public static class TestJob {
        final String configId;
        final boolean detectLocales;
        final File file;
        final File subDir;
        final String customConfigPath;
        final IComparator comparator;
        final Supplier<IFilter> constructor;

        public TestJob(String configId, boolean detectLocales, File file, File subDir, String customConfigPath, IComparator comparator, Supplier<IFilter> constructor) {
            this.configId = configId;
            this.detectLocales = detectLocales;
            this.file = file;
            this.subDir = subDir;
            this.customConfigPath = customConfigPath;
            this.comparator = comparator;
            this.constructor = constructor;
        }

        public String toString() {
            return "TestJob [configId=" + this.configId + ", detectLocales=" + this.detectLocales + ", file=" + this.file + ", subDir=" + this.subDir + ", customConfigPath=" + this.customConfigPath + ", comparator=" + this.comparator + ", constructor=" + this.constructor + "]";
        }
    }
}

