/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.simplifier.integration;

import java.util.ArrayList;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.filters.RoundTripComparison;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.filters.xml.XMLFilter;
import net.sf.okapi.steps.common.codesimplifier.PostSegmentationCodeSimplifierStep;
import net.sf.okapi.steps.segmentation.Parameters;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PostSegmentationSimplifierWithConfigIT {
    private static final LocaleId EN = new LocaleId("en", "us");
    private static final LocaleId ESES = new LocaleId("es", "es");
    private String pathBase;
    private SegmentationStep segmentationStep;
    @Rule
    public ErrorCollector errCol = new ErrorCollector();

    @Before
    public void setUp() throws Exception {
        this.pathBase = Util.getDirectoryName((String)PostSegmentationSimplifierWithConfigIT.class.getResource("/net/sf/okapi/common/codesimplifier/test1.xlf").getPath()) + "/";
        this.segmentationStep = new SegmentationStep();
        this.segmentationStep.setSourceLocale(EN);
        LinkedList<LocaleId> tl = new LinkedList<LocaleId>();
        tl.add(ESES);
        this.segmentationStep.setTargetLocales(tl);
        Parameters params = this.segmentationStep.getParameters();
        params.setSegmentSource(true);
        params.setSegmentTarget(true);
        params.setSourceSrxPath(PostSegmentationSimplifierWithConfigIT.class.getClassLoader().getResource("okapi_default_icu4j.srx").getPath());
        params.setTargetSrxPath(PostSegmentationSimplifierWithConfigIT.class.getClassLoader().getResource("okapi_default_icu4j.srx").getPath());
        this.segmentationStep.handleEvent(new Event(EventType.START_BATCH_ITEM));
    }

    @Test
    public void testDoubleExtraction() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "test1.html", "html_with_simplifier_rules.yml"));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtraction2() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "aa324.html", "html_with_simplifier_rules.yml"));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtractionReferences() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "references_as_codes.html", "html_with_simplifier_rules.yml"));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtractionMergedCodes() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "merged_codes.html", "html_with_simplifier_rules.yml"));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtraction3() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "form.html", "html_with_simplifier_rules.yml"));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtractionDita() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "dita.xml", "okf_xml@with-simplifier-rules.fprm"));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new XMLFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    public void testDoubleExtraction4() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "BinUnitTest01.xlf", "okf_xliff@with-simplifier-rules.fprm"));
        list.add(new InputDocument(this.pathBase + "JMP-11-Test01.xlf", "okf_xliff@with-simplifier-rules.fprm"));
        list.add(new InputDocument(this.pathBase + "Manual-12-AltTrans.xlf", "okf_xliff@with-simplifier-rules.fprm"));
        list.add(new InputDocument(this.pathBase + "test1.xlf", "okf_xliff@with-simplifier-rules.fprm"));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new XLIFFFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }
}

