/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.yaml.YamlFilter;
import net.sf.okapi.roundtrip.integration.RoundTripXmlStreamIT;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripYamlIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_yaml";
    private static final String DIR_NAME = "/yaml/";
    private static final List<String> EXTENSIONS = Arrays.asList(".yml", ".yaml");
    static final FileLocation root = FileLocation.fromClass(RoundTripXmlStreamIT.class);
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = YamlFilter::new;

    public RoundTripYamlIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, YamlFilter::new);
        this.addKnownFailingFile("unknown-tags-example.yaml");
        this.addKnownFailingFile("no-children-1-pretty.yaml");
        if ("\r\n".equals(System.lineSeparator())) {
            this.addKnownFailingFile("example2_14.yaml");
            this.addKnownFailingFile("example2_18.yaml");
            this.addKnownFailingFile("example2_27.yaml");
            this.addKnownFailingFile("example2_28.yaml");
            this.addKnownFailingFile("plain_wrapped.yml");
        }
    }

    @Ignore
    public void debug() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        File file = root.in("/yaml/test/inline_html_with_quotes.yml").asFile();
        this.runTest(new BaseRoundTripIT.TestJob("okf_yaml@inline_html", false, file, null, file.getParent(), new FileComparator.EventComparator(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void yamlFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        this.realTestFiles(false, new FileComparator.EventComparator());
    }

    @Test
    public void yamlSerializedFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.realTestFiles(false, new FileComparator.EventComparator());
    }
}

