/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.table.TableFilter;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripTableIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_table";
    private static final String DIR_NAME = "/table/";
    private static final List<String> EXTENSIONS = Arrays.asList(".csv", ".tab");
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = TableFilter::new;
    static final FileLocation root = FileLocation.fromClass(RoundTripTableIT.class);

    public RoundTripTableIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, TableFilter::new);
    }

    @Test
    public void debug() {
        this.setSerializedOutput(false);
        this.setExtensions(EXTENSIONS);
        File file = root.in("/table/debug/test.csv").asFile();
        this.runTest(new BaseRoundTripIT.TestJob("okf_table@debug", true, file, null, file.getParent(), new FileComparator.EventComparatorIgnoreSegmentation(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void tableFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        this.realTestFiles(false, new FileComparator.EventComparator());
    }

    @Test
    public void tableSerializedFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.realTestFiles(false, new FileComparator.EventComparator());
    }
}

