/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.RoundTripUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XliffCompareIT
extends BaseRoundTripIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Rule
    public ErrorCollector errCol = new ErrorCollector();

    public XliffCompareIT(String configId, String dirName, List<String> extensions, Supplier<IFilter> filterConstructor) {
        super(true, configId, dirName, extensions, filterConstructor);
    }

    public XliffCompareIT(String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale, Supplier<IFilter> filterConstructor) {
        super(true, configId, dirName, extensions, defaultTargetLocale, filterConstructor);
    }

    @Override
    protected void runTest(BaseRoundTripIT.TestJob testJob) {
        String f = testJob.file.getName();
        String root = testJob.file.getParent() + File.separator;
        String xliff = root + f + this.xliffExtractedExtension;
        String original = root + f;
        String currentXliffRoot = new File(this.getClass().getResource("/XLIFF_PREV/dummy.txt").getPath()).getParent();
        String sd = testJob.subDir == null ? "" : testJob.subDir.getName() + "/";
        String xliffPrevious = currentXliffRoot + this.dirName + sd + f + this.xliffExtractedExtension;
        LocaleId source = LocaleId.ENGLISH;
        LocaleId target = this.defaultTargetLocale;
        if (testJob.detectLocales) {
            List locales = FileUtil.guessLanguages((String)testJob.file.getAbsolutePath());
            if (locales.size() >= 1) {
                source = LocaleId.fromString((String)((String)locales.get(0)));
            }
            if (locales.size() >= 2) {
                target = LocaleId.fromString((String)((String)locales.get(1)));
            }
        }
        try {
            this.logger.info(f);
            RoundTripUtils.extract(source, target, original, xliff, testJob.configId, testJob.customConfigPath, false);
            Assert.assertTrue((String)("Compare Events: " + f), (boolean)testJob.comparator.compare(Paths.get(xliff, new String[0]), Paths.get(xliffPrevious, new String[0])));
        }
        catch (Throwable e) {
            if (!this.knownFailingFiles.contains(f)) {
                this.errCol.addError((Throwable)new OkapiException(f, e));
            }
            this.logger.info("Ignored known failing file: {}", (Object)f);
        }
    }
}

