/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripXliffIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_xliff";
    private static final String DIR_NAME = "/xliff/";
    private static final List<String> EXTENSIONS = Arrays.asList(".xliff", ".xlf");
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = XLIFFFilter::new;
    static final FileLocation root = FileLocation.fromClass(RoundTripXliffIT.class);

    public RoundTripXliffIT() {
        super(false, CONFIG_ID, DIR_NAME, EXTENSIONS, FILTER_CONSTRUCTOR);
        this.addKnownFailingFile("test.txt.xlf");
        this.addKnownFailingFile("sampe_sch.xliff");
        this.addKnownFailingFile("non-segment-without-target.xlf");
        this.addKnownFailingFile("non-segment-with-target.xlf");
        this.addKnownFailingFile("bug_merged_source_segments.xlf");
        this.addKnownFailingFile("We The People Foundation15997.sdlxliff");
        this.addKnownFailingFile("about_the.htm.xlf");
        this.addKnownFailingFile("647234_WiGigCU.xlf");
        this.addKnownFailingFile("keep_matching_bx_ex_ids.given.xlf");
        this.addKnownFailingFile("keep_matching_bx_ex_ids.expected.xlf");
        this.addKnownFailingFile("DifferentTags.xlf");
        this.addKnownFailingFile("BetweenSegments.xlf");
        this.addKnownFailingFile("MultipleSegments.xlf");
    }

    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.setExtensions(EXTENSIONS);
        File file = root.in("/xliff/mq-12-Test01-small.xlf").asFile();
        this.runTest(new BaseRoundTripIT.TestJob(CONFIG_ID, true, file, null, null, new FileComparator.EventComparator(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void sdlXliff() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        this.setExtensions(Collections.singletonList(".sdlxliff"));
        this.realTestFiles("okf_xliff-sdl", true, new FileComparator.EventComparator());
    }

    @Test
    public void worldserverXliff() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        this.setExtensions(Collections.singletonList(".iwsxliff"));
        this.realTestFiles("okf_xliff-iws", true, new FileComparator.EventComparator());
    }

    @Test
    public void xliffFiles() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(false);
        this.setExtensions(EXTENSIONS);
        this.realTestFiles(CONFIG_ID, true, new FileComparator.EventComparator());
    }

    @Test
    public void sdlXliffSerialized() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.setExtensions(Collections.singletonList(".sdlxliff"));
        this.realTestFiles("okf_xliff-sdl", true, new FileComparator.EventComparator());
    }

    @Test
    public void worldserverXliffSerialized() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.setExtensions(Collections.singletonList(".iwsxliff"));
        this.realTestFiles("okf_xliff-iws", true, new FileComparator.EventComparator());
    }

    @Test
    public void xliffSerialized() throws FileNotFoundException, URISyntaxException {
        this.setSerializedOutput(true);
        this.setExtensions(EXTENSIONS);
        this.realTestFiles(CONFIG_ID, true, new FileComparator.EventComparator());
    }
}

