/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.pipeline;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.scopingreport.Parameters;
import net.sf.okapi.steps.scopingreport.ScopingReportStep;
import net.sf.okapi.steps.wordcount.WordCountStep;

public class WordCountPipelineIT {
    private static FilterConfigurationMapper fcMapper;
    private static LocaleId locEN;
    private static LocaleId locES;

    public static void setUp() throws Exception {
        fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
    }

    private static PipelineDriver createPipeline() throws Exception {
        URL rootUrl = WordCountPipelineIT.class.getResource("/test.srx");
        String root = Util.getDirectoryName((String)rootUrl.toURI().getPath()) + File.separator;
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        driver.addStep((IPipelineStep)new WordCountStep());
        ScopingReportStep scope = new ScopingReportStep();
        Parameters p = (Parameters)scope.getParameters();
        p.setOutputPath(root + "scoping_report.html");
        driver.addStep((IPipelineStep)scope);
        return driver;
    }

    private static URI getUri(String fileName) throws URISyntaxException {
        URL url = WordCountPipelineIT.class.getResource(fileName);
        return url.toURI();
    }

    public static void main(String[] args) throws Exception {
        WordCountPipelineIT.setUp();
        PipelineDriver pd = WordCountPipelineIT.createPipeline();
        int i = 0;
        while ((long)i <= 10000000L) {
            RawDocument rd = new RawDocument(WordCountPipelineIT.getUri("/html/ugly_big.htm"), "UTF-8", locEN, locES);
            rd.setFilterConfigId("okf_html");
            pd.addBatchItem(rd, new File("genericOutput.txt").toURI(), "UTF-8");
            pd.processBatch();
            pd.clearItems();
            ++i;
        }
    }

    static {
        locEN = LocaleId.ENGLISH;
        locES = LocaleId.SPANISH;
    }
}

