/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;

public class BaseMemoryLeakTestIT {
    private FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
    private LocaleId locEN = LocaleId.fromString((String)"EN");

    public void addConfigurations(String string) {
        this.fcMapper.addConfigurations(string);
    }

    private PipelineDriver simplePipeline() throws Exception {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
        driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        return driver;
    }

    private URI getUri(String fileName) throws URISyntaxException {
        URL url = this.getClass().getResource(fileName);
        return url.toURI();
    }

    public void runIt(String configId, String docPath) throws Exception {
        PipelineDriver pd = this.simplePipeline();
        int i = 0;
        while ((long)i <= 10000000L) {
            RawDocument rd = new RawDocument(this.getUri(docPath), "UTF-8", this.locEN);
            rd.setFilterConfigId(configId);
            pd.addBatchItem(rd, new File("genericOutput.txt").toURI(), "UTF-8");
            pd.processBatch();
            pd.clearItems();
            ++i;
        }
    }
}

