/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.net.URL;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.connectors.pensieve.Parameters;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.lib.translation.QueryManager;
import net.sf.okapi.tm.pensieve.tmx.OkapiTmxImporter;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class QueryManagerTestIT {
    private QueryManager qm;
    private PensieveTMConnector pensieveConnector;
    private final LocaleId locENUS = LocaleId.fromString((String)"EN-US");
    private final LocaleId locFRFR = LocaleId.fromString((String)"FR-FR");

    @Before
    public void setUp() throws Exception {
        URL url = QueryManagerTestIT.class.getResource("/mytm.tmx");
        String rootDir = Util.getDirectoryName((String)url.toURI().getPath());
        try (TmxFilter tmxFilter = new TmxFilter();){
            ITmWriter tmWriter = TmWriterFactory.createFileBasedTmWriter((String)rootDir, (boolean)true);
            OkapiTmxImporter tmxHandler = new OkapiTmxImporter(this.locENUS, (IFilter)tmxFilter);
            tmxHandler.importTmx(url.toURI(), this.locFRFR, tmWriter);
            tmWriter.close();
        }
        this.qm = new QueryManager();
        this.qm.setRootDirectory(rootDir);
        this.qm.setLanguages(this.locENUS, this.locFRFR);
        this.pensieveConnector = new PensieveTMConnector();
        Parameters p = new Parameters();
        p.setDbDirectory("${rootDir}");
        this.qm.addAndInitializeResource((IQuery)this.pensieveConnector, "Pensieve", (IParameters)p);
    }

    @After
    public void tearDown() {
        if (this.qm != null) {
            this.qm.close();
            this.qm = null;
        }
        if (this.pensieveConnector != null) {
            this.pensieveConnector.close();
            this.pensieveConnector = null;
        }
    }

    @Test
    public void query() {
        this.qm.query("Elephants cannot fly.");
        Assert.assertTrue((boolean)this.qm.hasNext());
        Assert.assertEquals((Object)"Elephants cannot fly.", (Object)this.qm.next().source.toText());
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants <b>ne peuvent pas</b> voler.", (Object)this.qm.next().target.toText());
    }

    @Test
    public void leverageNoFill() {
        TextUnit tu = new TextUnit("1");
        tu.setSourceContent(new TextFragment("Elephants cannot fly."));
        this.qm.setOptions(999, false, false, false, null, 0, false);
        this.qm.leverage((ITextUnit)tu);
        Assert.assertEquals((Object)"", (Object)tu.getTarget(this.locFRFR).toString());
        AltTranslationsAnnotation a = (AltTranslationsAnnotation)tu.getTarget(this.locFRFR).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)a.getFirst().getTarget().toString());
    }

    @Test
    public void leverageFill() {
        TextUnit tu = new TextUnit("1");
        tu.setSourceContent(new TextFragment("Elephants cannot fly."));
        this.qm.setOptions(1, false, false, false, null, 0, false);
        this.qm.leverage((ITextUnit)tu);
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)tu.getTarget(this.locFRFR).toString());
        AltTranslationsAnnotation a = (AltTranslationsAnnotation)tu.getTarget(this.locFRFR).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)a.getFirst().getTarget().toString());
    }

    @Test
    public void leverageFillWithPrefix() {
        TextUnit tu = new TextUnit("1");
        tu.setSourceContent(new TextFragment("Elephants cannot fly."));
        this.qm.setOptions(1, false, false, false, "PREFIX! ", 100, false);
        this.qm.leverage((ITextUnit)tu);
        Assert.assertEquals((Object)"PREFIX! Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)tu.getTarget(this.locFRFR).toString());
        AltTranslationsAnnotation a = (AltTranslationsAnnotation)tu.getTarget(this.locFRFR).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)a.getFirst().getTarget().toString());
    }

    @Test
    public void leverageFillWithNoPrefix() {
        TextUnit tu = new TextUnit("1");
        tu.setSourceContent(new TextFragment("Elephants cannot fly."));
        this.qm.setOptions(1, false, false, false, "PREFIX! ", 99, false);
        this.qm.leverage((ITextUnit)tu);
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)tu.getTarget(this.locFRFR).toString());
        AltTranslationsAnnotation a = (AltTranslationsAnnotation)tu.getTarget(this.locFRFR).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)a.getFirst().getTarget().toString());
    }

    @Test
    public void leverageFillSeveralSegments() {
        TextUnit tu = new TextUnit("1");
        TextContainer tc = new TextContainer("Elephants cannot fly.");
        tc.getSegments().append(new Segment("s2", new TextFragment("Except Dumbo!")), " ");
        tu.setSource(tc);
        ISegments segs = tu.getSource().getSegments();
        Assert.assertEquals((long)2L, (long)segs.count());
        this.qm.setOptions(1, false, false, false, null, 0, false);
        this.qm.leverage((ITextUnit)tu);
        segs = tu.getTarget(this.locFRFR).getSegments();
        Assert.assertEquals((long)2L, (long)segs.count());
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)segs.get((int)0).text.toText());
        Assert.assertEquals((Object)"", (Object)segs.get((int)1).text.toText());
        AltTranslationsAnnotation a = (AltTranslationsAnnotation)segs.get(0).getAnnotation(AltTranslationsAnnotation.class);
        Assert.assertNotNull((Object)a);
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)a.getFirst().getTarget().toString());
    }
}

