/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.OkapiTestException;
import net.sf.okapi.common.integration.RoundTripUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlOrTextRoundTripIT
extends BaseRoundTripIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Rule
    public ErrorCollector errCol = new ErrorCollector();

    public XmlOrTextRoundTripIT(String configId, String dirName, List<String> extensions, Supplier<IFilter> filterConstructor) {
        super(true, configId, dirName, extensions, filterConstructor);
    }

    public XmlOrTextRoundTripIT(String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale, Supplier<IFilter> filterConstructor) {
        super(true, configId, dirName, extensions, defaultTargetLocale, filterConstructor);
    }

    @Override
    protected void runTest(BaseRoundTripIT.TestJob testJob) {
        String f = testJob.file.getName();
        String root = testJob.file.getParent() + File.separator;
        String original = root + f;
        String tkitMerged = root + f + ".tkitMerged";
        String extractedOutput = root + f + this.xliffExtractedExtension;
        extractedOutput = this.isSerializedOutput() ? root + f + this.serializedExtractedExtension : extractedOutput;
        LocaleId source = LocaleId.ENGLISH;
        LocaleId target = this.defaultTargetLocale;
        if (testJob.detectLocales) {
            List locales = FileUtil.guessLanguages((String)testJob.file.getAbsolutePath());
            if (locales.size() >= 1) {
                source = LocaleId.fromString((String)((String)locales.get(0)));
            }
            if (locales.size() >= 2) {
                target = LocaleId.fromString((String)((String)locales.get(1)));
            }
        }
        try {
            this.logger.info(f);
            FilterConfigurationMapper mapper = RoundTripUtils.extract(source, target, original, extractedOutput, testJob.configId, testJob.customConfigPath, this.isSerializedOutput());
            RoundTripUtils.merge(source, target, original, extractedOutput, tkitMerged, testJob.configId, mapper, this.isSerializedOutput());
            Assert.assertTrue((String)("Compare XML: " + f), (boolean)testJob.comparator.compare(Paths.get(tkitMerged, new String[0]), Paths.get(original, new String[0])));
        }
        catch (Throwable e) {
            if (!this.knownFailingFiles.contains(f)) {
                this.errCol.addError((Throwable)((Object)new OkapiTestException(f, e)));
                this.logger.error("Failing test: {}\n{}", (Object)f, (Object)e.getMessage());
            }
            this.logger.info("Ignored known failing file: {}", (Object)f);
        }
    }
}

