/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISimplifierRulesParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.FilterTestDriver;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.integration.IntegrationtestUtils;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.BatchItemContext;
import net.sf.okapi.common.pipelinedriver.IBatchItemContext;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.lib.merge.step.OriginalDocumentXliffMergerStep;
import net.sf.okapi.lib.merge.step.Parameters;
import net.sf.okapi.lib.serialization.step.OriginalDocumentTextUnitFlatMergerStep;
import net.sf.okapi.lib.serialization.writer.ProtoBufferTextUnitFlatWriter;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.RawDocumentWriterStep;
import net.sf.okapi.steps.common.codesimplifier.PostSegmentationCodeSimplifierStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.whitespacecorrection.WhitespaceCorrectionStep;

public final class RoundTripUtils {
    private static String sourceSrx = RoundTripUtils.class.getClassLoader().getResource("okapi_default_icu4j.srx").getPath();
    private static String targetSrx = RoundTripUtils.class.getClassLoader().getResource("okapi_default_icu4j.srx").getPath();

    public static FilterConfigurationMapper extract(LocaleId source, LocaleId target, String original, String outputPath, String configId, String customConfigPath, boolean serializedOutput) throws URISyntaxException {
        return RoundTripUtils.extract(source, target, original, outputPath, configId, customConfigPath, serializedOutput, false);
    }

    public static FilterConfigurationMapper extract(LocaleId source, LocaleId target, String originalPath, String outputPath, String configId, String customConfigPath, boolean serializedOutput, boolean simplify) throws URISyntaxException {
        FilterConfigurationMapper mapper;
        block21: {
            mapper = RoundTripUtils.createMapper(customConfigPath, configId);
            PipelineDriver driver = RoundTripUtils.createInitialPipeline(source, target, configId, simplify, mapper);
            driver.setFilterConfigurationMapper((IFilterConfigurationMapper)mapper);
            if (serializedOutput) {
                try (ProtoBufferTextUnitFlatWriter writer = new ProtoBufferTextUnitFlatWriter();
                     RawDocument originalDoc = new RawDocument(Util.toURI((String)originalPath), StandardCharsets.UTF_8.name(), source, target);){
                    FilterEventsWriterStep fewStep = new FilterEventsWriterStep();
                    fewStep.setFilterWriter((IFilterWriter)writer);
                    net.sf.okapi.lib.serialization.writer.Parameters params = writer.getParameters();
                    params.setCopySource(true);
                    fewStep.setDocumentRoots(Util.getDirectoryName((String)originalPath));
                    driver.addStep((IPipelineStep)fewStep);
                    originalDoc.setFilterConfigId(configId);
                    driver.addBatchItem(originalDoc, new File(outputPath).toURI(), StandardCharsets.UTF_8.name());
                    driver.processBatch();
                    break block21;
                }
            }
            try (XLIFFWriter writer = new XLIFFWriter();
                 RawDocument originalDoc = new RawDocument(Util.toURI((String)originalPath), StandardCharsets.UTF_8.name(), source, target);){
                FilterEventsWriterStep fewStep = new FilterEventsWriterStep();
                fewStep.setFilterWriter((IFilterWriter)writer);
                XLIFFWriterParameters xliffParams = writer.getParameters();
                xliffParams.setPlaceholderMode(false);
                xliffParams.setIncludeAltTrans(true);
                xliffParams.setEscapeGt(true);
                xliffParams.setIncludeCodeAttrs(true);
                xliffParams.setCopySource(true);
                xliffParams.setIncludeIts(true);
                xliffParams.setIncludeNoTranslate(true);
                xliffParams.setToolId("okapi");
                xliffParams.setToolName("okapi-tests");
                xliffParams.setToolCompany("okapi");
                xliffParams.setToolVersion("M29");
                fewStep.setDocumentRoots(Util.getDirectoryName((String)originalPath));
                driver.addStep((IPipelineStep)fewStep);
                originalDoc.setFilterConfigId(configId);
                driver.addBatchItem(originalDoc, new File(outputPath).toURI(), StandardCharsets.UTF_8.name());
                driver.processBatch();
            }
        }
        return mapper;
    }

    private static FilterConfigurationMapper createMapper(String customConfigPath, String configId) throws URISyntaxException {
        FilterConfigurationMapper mapper = new FilterConfigurationMapper();
        DefaultFilters.setMappings((IFilterConfigurationMapper)mapper, (boolean)false, (boolean)true);
        if (customConfigPath != null) {
            mapper.setCustomConfigurationsDirectory(customConfigPath);
            mapper.addCustomConfiguration(configId);
            File secondary = IntegrationtestUtils.getSecondaryConfigFile(new File(customConfigPath), configId);
            if (secondary != null) {
                mapper.addCustomConfiguration(Util.getFilename((String)secondary.getName(), (boolean)false));
            }
            mapper.updateCustomConfigurations();
        }
        return mapper;
    }

    private static PipelineDriver createInitialPipeline(LocaleId source, LocaleId target, String configId, boolean simplify, FilterConfigurationMapper mapper) {
        PipelineDriver driver = new PipelineDriver();
        RawDocumentToFilterEventsStep rd2feStep = new RawDocumentToFilterEventsStep();
        driver.addStep((IPipelineStep)rd2feStep);
        SegmentationStep ss = new SegmentationStep();
        ss.setSourceLocale(source);
        LinkedList<LocaleId> tl = new LinkedList<LocaleId>();
        tl.add(target);
        ss.setTargetLocales(tl);
        net.sf.okapi.steps.segmentation.Parameters params = ss.getParameters();
        params.setSegmentSource(true);
        params.setSegmentTarget(true);
        params.setDoNotSegmentIfHasTarget(true);
        params.setSourceSrxPath(sourceSrx);
        params.setTargetSrxPath(targetSrx);
        driver.addStep((IPipelineStep)ss);
        if (simplify) {
            net.sf.okapi.steps.common.codesimplifier.Parameters p = new net.sf.okapi.steps.common.codesimplifier.Parameters();
            ISimplifierRulesParameters fp = (ISimplifierRulesParameters)mapper.getConfiguration((String)configId).parameters;
            if (fp != null && null != fp.getSimplifierRules()) {
                p.setRules(fp.getSimplifierRules());
            }
            PostSegmentationCodeSimplifierStep simplifier = new PostSegmentationCodeSimplifierStep();
            simplifier.setParameters((IParameters)p);
            driver.addStep((IPipelineStep)simplifier);
        }
        return driver;
    }

    public static void merge(LocaleId source, LocaleId target, String originalPath, String extractedPath, String outputPath, String configId, FilterConfigurationMapper mapper, boolean serializedOutput) throws URISyntaxException {
        try (RawDocument originalDoc = new RawDocument(Util.toURI((String)originalPath), StandardCharsets.UTF_8.name(), source, target);
             RawDocument xlfDoc = new RawDocument(Util.toURI((String)extractedPath), StandardCharsets.UTF_8.name(), source, target);){
            originalDoc.setFilterConfigId(configId);
            PipelineDriver driver = new PipelineDriver();
            driver.setFilterConfigurationMapper((IFilterConfigurationMapper)mapper);
            BatchItemContext bic = new BatchItemContext(xlfDoc, Util.toURI((String)outputPath), StandardCharsets.UTF_8.name(), new RawDocument[]{originalDoc});
            driver.addBatchItem((IBatchItemContext)bic);
            driver.addStep((IPipelineStep)new WhitespaceCorrectionStep());
            if (serializedOutput) {
                driver.addStep((IPipelineStep)new OriginalDocumentTextUnitFlatMergerStep());
            } else {
                OriginalDocumentXliffMergerStep originalDocumentXliffMergerStep = new OriginalDocumentXliffMergerStep();
                Parameters parameters = new Parameters();
                parameters.setPreserveWhiteSpaceByDefault(true);
                originalDocumentXliffMergerStep.setParameters((IParameters)parameters);
                driver.addStep((IPipelineStep)originalDocumentXliffMergerStep);
            }
            driver.addStep((IPipelineStep)new RawDocumentWriterStep());
            driver.processBatch();
            driver.destroy();
        }
    }

    public static boolean compareEvents(List<Event> actual, List<Event> expected, boolean includeSkeleton, boolean ignoreSkelWhitespace, boolean ignoreFragmentWhitespace, boolean ignoreSegmentation) {
        boolean r = FilterTestDriver.compareEvents(actual, expected, (boolean)includeSkeleton, (boolean)ignoreSkelWhitespace, (boolean)ignoreFragmentWhitespace, (boolean)ignoreSegmentation);
        return r;
    }

    public static boolean compareTextUnits(List<ITextUnit> actual, List<ITextUnit> expected, boolean ignoreFragmentWhitespace) {
        boolean r = FilterTestDriver.compareTextUnits(actual, expected, (boolean)ignoreFragmentWhitespace);
        return r;
    }
}

