/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.IntegrationtestUtils;
import net.sf.okapi.common.integration.OkapiTestException;
import net.sf.okapi.common.integration.RoundTripUtils;
import net.sf.okapi.common.resource.RawDocument;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRoundTripIT
extends BaseRoundTripIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EventRoundTripIT(String configId, String dirName, List<String> extensions, Supplier<IFilter> filterConstructor) {
        this(true, configId, dirName, extensions, filterConstructor);
    }

    public EventRoundTripIT(boolean parallel, String configId, String dirName, List<String> extensions, Supplier<IFilter> filterConstructor) {
        super(parallel, configId, dirName, extensions, filterConstructor);
    }

    public EventRoundTripIT(String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale, Supplier<IFilter> filterConstructor) {
        this(true, configId, dirName, extensions, defaultTargetLocale, filterConstructor);
    }

    public EventRoundTripIT(boolean parallel, String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale, Supplier<IFilter> filterConstructor) {
        super(parallel, configId, dirName, extensions, defaultTargetLocale, filterConstructor);
    }

    @Override
    public void runTest(BaseRoundTripIT.TestJob testJob) {
        String f = testJob.file.getName();
        String root = testJob.file.getParent() + File.separator;
        String original = root + f;
        String tkitMerged = root + f + ".tkitMerged";
        String extractedOutput = root + f + this.xliffExtractedExtension;
        extractedOutput = this.isSerializedOutput() ? root + f + this.serializedExtractedExtension : extractedOutput;
        LocaleId source = LocaleId.ENGLISH;
        LocaleId target = this.defaultTargetLocale;
        if (testJob.detectLocales) {
            List locales = FileUtil.guessLanguages((String)testJob.file.getAbsolutePath());
            if (locales.size() >= 1) {
                source = LocaleId.fromString((String)((String)locales.get(0)));
            }
            if (locales.size() >= 2) {
                target = LocaleId.fromString((String)((String)locales.get(1)));
            }
        }
        try {
            this.logger.info(f);
            FilterConfigurationMapper mapper = RoundTripUtils.extract(source, target, original, extractedOutput, testJob.configId, testJob.customConfigPath, this.isSerializedOutput());
            RoundTripUtils.merge(source, target, original, extractedOutput, tkitMerged, testJob.configId, mapper, this.isSerializedOutput());
            List<Event> o = this.loadEventsFromFile(original, testJob, mapper, source, target);
            List<Event> t = this.loadEventsFromFile(tkitMerged, testJob, mapper, source, target);
            Assert.assertTrue((String)("Compare Events: " + f), (boolean)testJob.comparator.compare(t, o));
        }
        catch (Throwable e) {
            if (!this.knownFailingFiles.contains(f)) {
                this.errCol.addError((Throwable)((Object)new OkapiTestException(f, e)));
                this.logger.error("Failing test: {}\n{}", (Object)f, (Object)e.getMessage());
            }
            this.logger.info("Ignored known failing file: {}", (Object)f);
        }
    }

    protected List<Event> loadEventsFromFile(String fileName, BaseRoundTripIT.TestJob testJob, FilterConfigurationMapper mapper, LocaleId sourceLocale, LocaleId targetLocale) {
        try (RawDocument trd = new RawDocument(Util.toURI((String)fileName), "UTF-8", sourceLocale, targetLocale);){
            ArrayList<Event> arrayList;
            block11: {
                IFilter filter = testJob.constructor.get();
                try {
                    filter.setFilterConfigurationMapper((IFilterConfigurationMapper)mapper);
                    IParameters params = mapper.getParameters(mapper.getConfiguration(testJob.configId));
                    arrayList = IntegrationtestUtils.getEvents(filter, trd, params);
                    if (filter == null) break block11;
                }
                catch (Throwable throwable) {
                    if (filter != null) {
                        try {
                            filter.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                filter.close();
            }
            return arrayList;
        }
    }
}

