/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.common.integration.XmlOrTextRoundTripIT;
import net.sf.okapi.filters.ttx.TTXFilter;
import net.sf.okapi.roundtrip.integration.RoundTripXliffIT;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripTtxIT
extends XmlOrTextRoundTripIT {
    private static final String CONFIG_ID = "okf_ttx";
    private static final String DIR_NAME = "/ttx/";
    private static final List<String> EXTENSIONS = Arrays.asList(".ttx");
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = TTXFilter::new;
    static final FileLocation root = FileLocation.fromClass(RoundTripXliffIT.class);

    public RoundTripTtxIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, FILTER_CONSTRUCTOR);
        this.addKnownFailingFile("Test02_noseg.html.ttx");
    }

    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        File file = root.in("/ttx/Test02_allseg.html.ttx").asFile();
        this.runTest(new BaseRoundTripIT.TestJob(CONFIG_ID, true, file, null, null, new FileComparator.XmlComparator(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void ttxFiles() throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(false, new FileComparator.XmlComparator());
    }
}

