/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.roundtrip.integration.RoundTripXliffIT;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripTmxIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_tmx";
    private static final String DIR_NAME = "/tmx/";
    private static final List<String> EXTENSIONS = Arrays.asList(".tmx");
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = TmxFilter::new;

    public RoundTripTmxIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, FILTER_CONSTRUCTOR);
        this.addKnownFailingFile("okapi-confusion.tmx");
    }

    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        FileLocation root = FileLocation.fromClass(RoundTripXliffIT.class);
        File file = root.in("/tmx/code_fail.tmx").asFile();
        this.runTest(new BaseRoundTripIT.TestJob(CONFIG_ID, true, file, null, null, new FileComparator.EventComparator(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void tmxFiles() throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(CONFIG_ID, true, new FileComparator.EventComparator());
    }
}

