/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.html.Parameters;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripHtmlIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_html";
    private static final String DIR_NAME = "/html/";
    private static final List<String> EXTENSIONS = Arrays.asList(".html", ".htm");
    private static final Supplier<IFilter> FILTER_CONSTRUCTOR = HtmlFilter::new;
    static final FileLocation root = FileLocation.fromClass(RoundTripHtmlIT.class);
    private Parameters params;

    public RoundTripHtmlIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS, FILTER_CONSTRUCTOR);
        this.addKnownFailingFile("98959751.html");
    }

    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        File file = root.in("/html/form.html").asFile();
        this.runTest(new BaseRoundTripIT.TestJob(CONFIG_ID, false, file, null, null, new FileComparator.EventComparator(), FILTER_CONSTRUCTOR));
    }

    @Test
    public void htmlFiles() throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(false, new FileComparator.EventComparator());
    }
}

