/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.util.List;
import java.util.function.Supplier;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.OkapiTestException;
import net.sf.okapi.common.integration.RoundTripUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventRoundTripIT
extends BaseRoundTripIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public EventRoundTripIT(String configId, String dirName, List<String> extensions, Supplier<IFilter> filterConstructor) {
        this(true, configId, dirName, extensions, filterConstructor);
    }

    public EventRoundTripIT(boolean parallel, String configId, String dirName, List<String> extensions, Supplier<IFilter> filterConstructor) {
        super(parallel, configId, dirName, extensions, filterConstructor);
    }

    public EventRoundTripIT(String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale, Supplier<IFilter> filterConstructor) {
        this(true, configId, dirName, extensions, defaultTargetLocale, filterConstructor);
    }

    public EventRoundTripIT(boolean parallel, String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale, Supplier<IFilter> filterConstructor) {
        super(parallel, configId, dirName, extensions, defaultTargetLocale, filterConstructor);
    }

    @Override
    public void runTest(BaseRoundTripIT.TestJob testJob) {
        String f = testJob.file.getName();
        String root = testJob.file.getParent() + File.separator;
        String xliff = root + f + this.xliffExtractedExtension;
        String original = root + f;
        String tkitMerged = root + f + ".tkitMerged";
        LocaleId source = LocaleId.ENGLISH;
        LocaleId target = this.defaultTargetLocale;
        if (testJob.detectLocales) {
            List locales = FileUtil.guessLanguages((String)testJob.file.getAbsolutePath());
            if (locales.size() >= 1) {
                source = LocaleId.fromString((String)((String)locales.get(0)));
            }
            if (locales.size() >= 2) {
                target = LocaleId.fromString((String)((String)locales.get(1)));
            }
        }
        try {
            this.logger.info(f);
            FilterConfigurationMapper mapper = RoundTripUtils.extract(source, target, original, xliff, testJob.configId, testJob.customConfigPath);
            RoundTripUtils.merge(source, target, original, xliff, tkitMerged, testJob.configId, testJob.customConfigPath, mapper);
            List<Event> o = this.loadEventsFromFile(original, testJob, mapper, source, target);
            List<Event> t = this.loadEventsFromFile(tkitMerged, testJob, mapper, source, target);
            Assert.assertTrue((String)("Compare Events: " + f), (boolean)testJob.comparator.compare(t, o));
        }
        catch (Throwable e) {
            if (!this.knownFailingFiles.contains(f)) {
                this.errCol.addError((Throwable)((Object)new OkapiTestException(f, e)));
                this.logger.error("Failing test: {}\n{}", (Object)f, (Object)e.getMessage());
            }
            this.logger.info("Ignored known failing file: {}", (Object)f);
        }
    }

    /*
     * Exception decompiling
     */
    private List<Event> loadEventsFromFile(String fileName, BaseRoundTripIT.TestJob testJob, FilterConfigurationMapper mapper, LocaleId sourceLocale, LocaleId targetLocale) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

