/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.xliffcompare.integration;

import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.common.integration.XliffCompareIT;
import net.sf.okapi.filters.archive.ArchiveFilter;
import net.sf.okapi.filters.archive.Parameters;
import net.sf.okapi.filters.tmx.TmxFilter;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ArchiveXliffCompareIT
extends XliffCompareIT {
    private static final String CONFIG_ID = "okf_archive";
    private static final String DIR_NAME = "/archive/";
    private static final List<String> EXTENSIONS = Arrays.asList(".archive", ".zip");
    Parameters params;

    public ArchiveXliffCompareIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS);
    }

    @Before
    public void setUp() throws Exception {
        FilterConfigurationMapper fcm = new FilterConfigurationMapper();
        try (TmxFilter tmxFilter = new TmxFilter();){
            for (FilterConfiguration cfg : tmxFilter.getConfigurations()) {
                fcm.addConfiguration(cfg);
            }
        }
        this.filter = new ArchiveFilter();
        this.filter.setFilterConfigurationMapper((IFilterConfigurationMapper)fcm);
        this.params = new Parameters();
        this.params.setFileNames("*.xliff, *.tmx, *.xlf");
        this.params.setConfigIds("okf_xliff, okf_tmx, okf_xliff");
        this.filter.setParameters((IParameters)this.params);
    }

    @After
    public void tearDown() throws Exception {
        this.filter.close();
    }

    @Test
    public void archiveXliffCompareFiles() throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(false, new FileComparator.XmlComparator());
    }
}

