/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.simplifier.integration;

import java.util.ArrayList;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.InputDocument;
import net.sf.okapi.common.filters.RoundTripComparison;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import net.sf.okapi.filters.xmlstream.XmlStreamFilter;
import net.sf.okapi.steps.common.codesimplifier.PostSegmentationCodeSimplifierStep;
import net.sf.okapi.steps.segmentation.Parameters;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PostSegmentationSimplifierIT {
    private static final LocaleId EN = new LocaleId("en", "us");
    private static final LocaleId ESES = new LocaleId("es", "es");
    private String pathBase;
    private SegmentationStep segmentationStep;
    @Rule
    public ErrorCollector errCol = new ErrorCollector();

    @Before
    public void setUp() throws Exception {
        this.pathBase = Util.getDirectoryName((String)PostSegmentationSimplifierIT.class.getResource("/net/sf/okapi/common/codesimplifier/test1.xlf").getPath()) + "/";
        this.segmentationStep = new SegmentationStep();
        this.segmentationStep.setSourceLocale(EN);
        LinkedList<LocaleId> tl = new LinkedList<LocaleId>();
        tl.add(ESES);
        this.segmentationStep.setTargetLocales(tl);
        Parameters params = this.segmentationStep.getParameters();
        params.setSegmentSource(true);
        params.setSegmentTarget(true);
        params.setSourceSrxPath(PostSegmentationSimplifierIT.class.getClassLoader().getResource("default.srx").getPath());
        params.setTargetSrxPath(PostSegmentationSimplifierIT.class.getClassLoader().getResource("default.srx").getPath());
        params.setCopySource(false);
        this.segmentationStep.handleEvent(Event.START_BATCH_ITEM_EVENT);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testDoubleExtraction() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "test1.html", null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtraction2() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "aa324.html", null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtractionReferences() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "references_as_codes.html", null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtractionDita() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "dita.xml", null));
        RoundTripComparison rtc = new RoundTripComparison();
        XmlStreamFilter f = new XmlStreamFilter();
        f.setParametersFromURL(XmlStreamFilter.class.getResource("dita.yml"));
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)f, list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtractionMergedCodes() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "merged_codes.html", null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    @Test
    public void testDoubleExtraction3() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "form.html", null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new HtmlFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }

    public void testDoubleExtraction4() {
        ArrayList<InputDocument> list = new ArrayList<InputDocument>();
        list.add(new InputDocument(this.pathBase + "BinUnitTest01.xlf", null));
        list.add(new InputDocument(this.pathBase + "JMP-11-Test01.xlf", null));
        list.add(new InputDocument(this.pathBase + "Manual-12-AltTrans.xlf", null));
        list.add(new InputDocument(this.pathBase + "test1.xlf", null));
        RoundTripComparison rtc = new RoundTripComparison();
        Assert.assertTrue((boolean)rtc.executeCompare((IFilter)new XLIFFFilter(), list, "UTF-8", EN, ESES, "out", new IPipelineStep[]{this.segmentationStep, new PostSegmentationCodeSimplifierStep()}));
    }
}

