/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripXliffIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_xliff";
    private static final String DIR_NAME = "/xliff/";
    private static final List<String> EXTENSIONS = Arrays.asList(".xliff", ".xlf");
    static final FileLocation root = FileLocation.fromClass(RoundTripXliffIT.class);

    public RoundTripXliffIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS);
        this.addKnownFailingFile("DE_CALC_PHASE1.xlsx.sdlxliff");
        this.addKnownFailingFile("ImplementationPlan.docx.xlf");
        this.addKnownFailingFile("lqiTest.xlf");
        this.addKnownFailingFile("sampe_sch.xliff");
        this.addKnownFailingFile("test.txt.xlf");
        this.addKnownFailingFile("DifferentTags.xlf");
    }

    @Before
    public void setUp() throws Exception {
        this.filter = new XLIFFFilter();
    }

    @After
    public void tearDown() throws Exception {
        this.filter.close();
    }

    @Ignore
    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        this.setConfigId("okf_xliff-sdl");
        File file = root.in("/xliff/sdlxliff/DLG_createEstimate.html.sdlxliff").asFile();
        this.runTest(true, file, null, null, new FileComparator.EventComparator());
    }

    @Test
    public void sdlXliff() throws FileNotFoundException, URISyntaxException {
        this.setConfigId("okf_xliff-sdl");
        this.setExtensions(Arrays.asList(".sdlxliff"));
        this.realTestFiles(true, new FileComparator.EventComparator());
    }

    @Test
    public void worldserverXliff() throws FileNotFoundException, URISyntaxException {
        this.setConfigId("okf_xliff-iws");
        this.setExtensions(Arrays.asList(".iwsxliff"));
        this.realTestFiles(true, new FileComparator.EventComparator());
    }

    @Test
    public void xliffFiles() throws FileNotFoundException, URISyntaxException {
        this.setConfigId(CONFIG_ID);
        this.setExtensions(EXTENSIONS);
        this.realTestFiles(true, new FileComparator.EventComparatorIgnoreSegmentation());
    }
}

