/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.xliff2.XLIFF2Filter;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripXliff2IT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_xliff2";
    private static final String DIR_NAME = "/xliff2/";
    private static final List<String> EXTENSIONS = Arrays.asList(".xliff", ".xlf", "xlf2");
    static final FileLocation root = FileLocation.fromClass(RoundTripXliff2IT.class);

    public RoundTripXliff2IT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS);
    }

    @Before
    public void setUp() throws Exception {
        this.filter = new XLIFF2Filter();
    }

    @After
    public void tearDown() throws Exception {
        this.filter.close();
    }

    @Test
    public void debug() throws FileNotFoundException, URISyntaxException {
        File file = root.in("/xliff2/update_target.xlf").asFile();
        this.runTest(true, file, null, null, new FileComparator.EventComparatorWithWhitespace());
    }

    @Test
    public void deepenXliff2() throws FileNotFoundException, URISyntaxException {
        this.setExtensions(Arrays.asList(".deepen_xlf"));
        this.realTestFiles(true, new FileComparator.EventComparatorIgnoreSegmentation());
    }

    @Test
    public void xliff2Files() throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(true, new FileComparator.EventComparatorWithWhitespace());
    }
}

