/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.roundtrip.integration;

import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.FileComparator;
import net.sf.okapi.filters.markdown.MarkdownFilter;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RoundTripMarkdownIT
extends EventRoundTripIT {
    private static final String CONFIG_ID = "okf_markdown";
    private static final String DIR_NAME = "/markdown/";
    private static final List<String> EXTENSIONS = Arrays.asList(".md");

    public RoundTripMarkdownIT() {
        super(CONFIG_ID, DIR_NAME, EXTENSIONS);
        this.addKnownFailingFile("html-table-w-empty-lines.md");
        this.addKnownFailingFile("example4.md");
        if ("\r\n".equals(System.lineSeparator())) {
            this.addKnownFailingFile("Inline HTML (Advanced).md");
            this.addKnownFailingFile("Inline HTML (Simple).md");
            this.addKnownFailingFile("Markdown Documentation - Basics.md");
            this.addKnownFailingFile("Markdown Documentation - Syntax.md");
            this.addKnownFailingFile("example3.md");
            this.addKnownFailingFile("html_list_changed.md");
            this.addKnownFailingFile("html_list_original.md");
            this.addKnownFailingFile("html_table1_original.md");
            this.addKnownFailingFile("html_table_changed.md");
            this.addKnownFailingFile("min_math_original.md");
            this.addKnownFailingFile("regressing_test_single_page.md");
            this.addKnownFailingFile("sample_html_combo.md");
        }
    }

    @Before
    public void setUp() throws Exception {
        this.filter = new MarkdownFilter();
    }

    @After
    public void tearDown() throws Exception {
        this.filter.close();
    }

    @Test
    public void markdownFiles() throws FileNotFoundException, URISyntaxException {
        this.realTestFiles(false, new FileComparator.EventComparator());
    }
}

