/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.pipeline;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;

public class SegmentationPipelineIT {
    private static FilterConfigurationMapper fcMapper;
    private static LocaleId locEN;

    public static void setUp() throws Exception {
        fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
    }

    private static PipelineDriver createPipeline() throws Exception {
        PipelineDriver driver = new PipelineDriver();
        driver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        driver.addStep((IPipelineStep)new SegmentationStep());
        return driver;
    }

    private static URI getUri(String fileName) throws URISyntaxException {
        URL url = SegmentationPipelineIT.class.getResource(fileName);
        return url.toURI();
    }

    public static void main(String[] args) throws Exception {
        SegmentationPipelineIT.setUp();
        PipelineDriver pd = SegmentationPipelineIT.createPipeline();
        int i = 0;
        while ((long)i <= 10000000L) {
            RawDocument rd = new RawDocument(SegmentationPipelineIT.getUri("/html/ugly_big.htm"), "UTF-8", locEN);
            rd.setFilterConfigId("okf_html");
            pd.addBatchItem(rd, new File("genericOutput.txt").toURI(), "UTF-8");
            pd.processBatch();
            pd.clearItems();
            ++i;
        }
    }

    static {
        locEN = LocaleId.fromString((String)"EN");
    }
}

