/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.RawDocument;

public class XsltTransformStep
extends BasePipelineStep {
    private final InputStream xstlInputstream;
    private boolean done = false;
    private final LocaleId locEN = LocaleId.fromString((String)"EN");

    public XsltTransformStep(InputStream xstlInputstream) {
        this.xstlInputstream = xstlInputstream;
    }

    public String getName() {
        return "XSLT Processing Step";
    }

    public String getDescription() {
        return "Applies an XSLT template to the document.";
    }

    protected Event handleStartBatch(Event event) {
        this.done = true;
        return event;
    }

    protected Event handleStartBatchItem(Event event) {
        this.done = false;
        return event;
    }

    protected Event handleRawDocument(Event event) {
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        try (Reader XmlInput = ((RawDocument)event.getResource()).getReader();){
            StreamSource xmlSource = new StreamSource(XmlInput);
            StreamSource xsltSource = new StreamSource(this.xstlInputstream);
            StreamResult result = new StreamResult(tempStream);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(xmlSource, result);
            ByteArrayInputStream transformedInput = new ByteArrayInputStream(tempStream.toByteArray());
            event.setResource((IResource)new RawDocument((InputStream)transformedInput, "UTF-8", this.locEN));
        }
        catch (IOException | TransformerException e) {
            throw new OkapiException((Throwable)e);
        }
        this.done = true;
        return event;
    }

    public boolean isDone() {
        return this.done;
    }
}

