/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.integration.XsltTransformStep;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class XsltPipelineTestIT {
    private IPipelineDriver driver;
    private final LocaleId locEN = LocaleId.fromString((String)"EN");
    static FileLocation root;

    @Before
    public void setUp() throws Exception {
        FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();
        fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.driver = new PipelineDriver();
        this.driver.setFilterConfigurationMapper((IFilterConfigurationMapper)fcMapper);
        root = FileLocation.fromClass(this.getClass());
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void runXsltPipeline() throws URISyntaxException, IOException {
        this.driver.clearItems();
        URI inputXml = root.in("test.xml").asUri();
        try (InputStream in1 = root.in("identity.xsl").asInputStream();
             InputStream in2 = root.in("remove_b_tags.xsl").asInputStream();
             RawDocument rd = new RawDocument(inputXml, "UTF-8", this.locEN);){
            this.driver.addStep((IPipelineStep)new XsltTransformStep(in1));
            this.driver.addStep((IPipelineStep)new XsltTransformStep(in2));
            this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
            this.driver.addStep((IPipelineStep)new FilterEventsWriterStep());
            rd.setFilterConfigId("okf_xml");
            File outFile = root.out("output.xml").asFile();
            this.driver.addBatchItem(rd, outFile.toURI(), "UTF-8");
            this.driver.processBatch();
            StringBuilder tmp = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(outFile), "UTF-8"));){
                int count;
                char[] buf = new char[2048];
                while ((count = reader.read(buf)) != -1) {
                    tmp.append(buf, 0, count);
                }
            }
            String tmpStr = tmp.toString().replaceAll("\n", "").replaceAll("\r", "");
            Assert.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><start fileID=\"02286_000_000\"><para id=\"1\">This is a test with .</para></start>", (Object)tmpStr);
        }
    }
}

