/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.integration.FindStringStep;
import net.sf.okapi.common.pipelinedriver.IPipelineDriver;
import net.sf.okapi.common.pipelinedriver.PipelineDriver;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import net.sf.okapi.steps.common.FilterEventsWriterStep;
import net.sf.okapi.steps.common.RawDocumentToFilterEventsStep;
import net.sf.okapi.steps.common.RawDocumentWriterStep;
import net.sf.okapi.steps.common.createtarget.CreateTargetStep;
import net.sf.okapi.steps.searchandreplace.Parameters;
import net.sf.okapi.steps.searchandreplace.SearchAndReplaceStep;
import net.sf.okapi.steps.segmentation.SegmentationStep;
import net.sf.okapi.steps.xsltransform.XSLTransformStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class MultistepPipelineTestIT {
    private FilterConfigurationMapper fcMapper;
    private IPipelineDriver driver;
    private final LocaleId locEN = LocaleId.fromString((String)"EN");
    private final LocaleId locEUES = LocaleId.fromString((String)"eu-ES");
    private final LocaleId locFR = LocaleId.fromString((String)"FR");

    @Before
    public void setUp() throws Exception {
        this.fcMapper = new FilterConfigurationMapper();
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.driver = new PipelineDriver();
        this.driver.setFilterConfigurationMapper((IFilterConfigurationMapper)this.fcMapper);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void xsltPipeline() throws URISyntaxException {
        String xsltPath = MultistepPipelineTestIT.class.getResource("identity.xsl").toURI().getPath();
        XSLTransformStep step1 = new XSLTransformStep();
        ((net.sf.okapi.steps.xsltransform.Parameters)step1.getParameters()).setXsltPath(xsltPath);
        XSLTransformStep step2 = new XSLTransformStep();
        ((net.sf.okapi.steps.xsltransform.Parameters)step2.getParameters()).setXsltPath(xsltPath);
        XSLTransformStep step3 = new XSLTransformStep();
        ((net.sf.okapi.steps.xsltransform.Parameters)step3.getParameters()).setXsltPath(xsltPath);
        RawDocumentWriterStep step4 = new RawDocumentWriterStep();
        this.driver.addStep((IPipelineStep)step1);
        this.driver.addStep((IPipelineStep)step2);
        this.driver.addStep((IPipelineStep)step3);
        this.driver.addStep((IPipelineStep)step4);
        try (RawDocument rawDoc = new RawDocument(this.getUri("test01.xml"), "UTF-8", this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test01.xml"), "UTF-8");
        }
        rawDoc = new RawDocument(this.getUri("test02.xml"), "UTF-8", this.locEN, this.locFR);
        var7_7 = null;
        try {
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test02.xml"), "UTF-8");
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (rawDoc != null) {
                if (var7_7 != null) {
                    try {
                        rawDoc.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    rawDoc.close();
                }
            }
        }
        rawDoc = new RawDocument(this.getUri("test03.xml"), "UTF-8", this.locEN, this.locFR);
        var7_7 = null;
        try {
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test03.xml"), "UTF-8");
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (rawDoc != null) {
                if (var7_7 != null) {
                    try {
                        rawDoc.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    rawDoc.close();
                }
            }
        }
        rawDoc = new RawDocument(this.getUri("test04.xml"), "UTF-8", this.locEN, this.locFR);
        var7_7 = null;
        try {
            rawDoc.setFilterConfigId("okf_xml");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("test04.xml"), "UTF-8");
        }
        catch (Throwable throwable) {
            var7_7 = throwable;
            throw throwable;
        }
        finally {
            if (rawDoc != null) {
                if (var7_7 != null) {
                    try {
                        rawDoc.close();
                    }
                    catch (Throwable throwable) {
                        var7_7.addSuppressed(throwable);
                    }
                } else {
                    rawDoc.close();
                }
            }
        }
        this.driver.processBatch();
        Assert.assertTrue((boolean)new File(this.getOutputUri("test01.xml")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("test02.xml")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("test03.xml")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("test04.xml")).exists());
        this.driver.clearItems();
        this.driver.clearSteps();
    }

    @Test
    public void searchAndReplacePipeline() throws URISyntaxException {
        RawDocumentToFilterEventsStep step1 = new RawDocumentToFilterEventsStep();
        SearchAndReplaceStep step2 = new SearchAndReplaceStep();
        ((Parameters)step2.getParameters()).addRule(new String[]{"true", "Okapi Framework", "Big Foot"});
        FindStringStep step3 = new FindStringStep("Big Foot");
        this.driver.addStep((IPipelineStep)step1);
        this.driver.addStep((IPipelineStep)new CreateTargetStep());
        this.driver.addStep((IPipelineStep)step2);
        this.driver.addStep((IPipelineStep)step3);
        try (RawDocument rawDoc = new RawDocument(this.getUri("okapi_intro_test.html"), "UTF-8", this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_html");
            this.driver.addBatchItem(new RawDocument[]{rawDoc});
            this.driver.processBatch();
            Assert.assertTrue((boolean)step3.isFound());
            this.driver.clearItems();
            this.driver.clearSteps();
        }
    }

    @Test
    public void backAndForthPipeline() throws URISyntaxException {
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        this.driver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        this.driver.addStep((IPipelineStep)new FilterEventsToRawDocumentStep());
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        SearchAndReplaceStep searchReplaceStep = new SearchAndReplaceStep();
        ((Parameters)searchReplaceStep.getParameters()).addRule(new String[]{"true", "Okapi Framework", "Big Foot"});
        this.driver.addStep((IPipelineStep)new CreateTargetStep());
        this.driver.addStep((IPipelineStep)searchReplaceStep);
        FindStringStep findStep = new FindStringStep("Big Foot");
        this.driver.addStep((IPipelineStep)findStep);
        try (RawDocument rawDoc = new RawDocument(this.getUri("okapi_intro_test.html"), "UTF-8", this.locEN, this.locFR);){
            rawDoc.setFilterConfigId("okf_html");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("okapi_intro_test.html"), "UTF-8");
            this.driver.processBatch();
            Assert.assertTrue((boolean)findStep.isFound());
            this.driver.clearItems();
            this.driver.clearSteps();
        }
    }

    @Test
    public void copySourceToTargetPipeline() throws URISyntaxException {
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        CreateTargetStep copySourceToTargetStep = new CreateTargetStep();
        copySourceToTargetStep.setTargetLocale(this.locEUES);
        this.driver.addStep((IPipelineStep)copySourceToTargetStep);
        this.driver.addStep((IPipelineStep)new FilterEventsWriterStep());
        try (RawDocument rawDoc = new RawDocument(this.getUri("Test01.properties"), "UTF-8", this.locEN, this.locEUES);){
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test01.properties"), "UTF-8");
        }
        rawDoc = new RawDocument(this.getUri("Test02.properties"), "UTF-8", this.locEN, this.locEUES);
        var3_3 = null;
        try {
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test02.properties"), "UTF-8");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (rawDoc != null) {
                if (var3_3 != null) {
                    try {
                        rawDoc.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    rawDoc.close();
                }
            }
        }
        rawDoc = new RawDocument(this.getUri("Test03.properties"), "UTF-8", this.locEN, this.locEUES);
        var3_3 = null;
        try {
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test03.properties"), "UTF-8");
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (rawDoc != null) {
                if (var3_3 != null) {
                    try {
                        rawDoc.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    rawDoc.close();
                }
            }
        }
        this.driver.processBatch();
        Assert.assertTrue((boolean)new File(this.getOutputUri("Test01.properties")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("Test02.propertiesl")).exists());
        Assert.assertTrue((boolean)new File(this.getOutputUri("Test03.properties")).exists());
        this.driver.clearItems();
        this.driver.clearSteps();
    }

    @Test
    public void segmentationPipeline() throws URISyntaxException {
        this.driver.addStep((IPipelineStep)new RawDocumentToFilterEventsStep());
        SegmentationStep ss = new SegmentationStep();
        net.sf.okapi.steps.segmentation.Parameters sp = ss.getParameters();
        sp.setSourceSrxPath(new File(this.getUri("test.srx")).getAbsolutePath());
        sp.setSegmentSource(true);
        this.driver.addStep((IPipelineStep)ss);
        this.driver.addStep((IPipelineStep)new FilterEventsWriterStep());
        try (RawDocument rawDoc = new RawDocument(this.getUri("Test01.properties"), "UTF-8", this.locEN);){
            rawDoc.setFilterConfigId("okf_properties");
            this.driver.addBatchItem(rawDoc, this.getOutputUri("Test01.properties"), "UTF-8");
            this.driver.processBatch();
            Assert.assertTrue((boolean)new File(this.getOutputUri("Test01.properties")).exists());
            this.driver.clearItems();
            this.driver.clearSteps();
        }
    }

    private URI getUri(String fileName) throws URISyntaxException {
        URL url = MultistepPipelineTestIT.class.getResource("/" + fileName);
        return url.toURI();
    }

    private URI getOutputUri(String fileName) {
        File f = new File(Util.getTempDirectory() + "/fileName");
        f.deleteOnExit();
        return f.toURI();
    }
}

