/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.IPipelineStep;

class FindStringStep
extends BasePipelineStep
implements IPipelineStep {
    private String lookupString;
    private boolean found;
    private LocaleId locFR = LocaleId.fromString((String)"FR");

    public FindStringStep(String lookupString) {
        this.lookupString = lookupString;
        this.found = false;
    }

    public String getDescription() {
        return "Finds a string in TextUnits";
    }

    public String getName() {
        return "Find String";
    }

    protected Event handleTextUnit(Event event) {
        String text = event.getTextUnit().getTarget(this.locFR).toString();
        if (text.contains(this.lookupString)) {
            this.found = true;
        }
        return event;
    }

    public boolean isFound() {
        return this.found;
    }
}

