/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipeline.integration;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.steps.common.FilterEventsToRawDocumentStep;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FilterEventsToRawDocumentStepTestIT {
    private FilterEventsToRawDocumentStep eventToDoc;
    private String htmlSnippet;
    private HtmlFilter htmlFilter;
    private final LocaleId locEN = LocaleId.fromString((String)"EN");

    @Before
    public void setUp() throws Exception {
        this.htmlFilter = new HtmlFilter();
        this.htmlSnippet = "<p>This is a <i>test</i> snippet</p>";
    }

    @After
    public void tearDown() throws Exception {
        this.htmlFilter.close();
    }

    @Test
    public void htmlEventsToRawDocumentWithUserURI() throws IOException {
        Event event = null;
        this.eventToDoc = new FilterEventsToRawDocumentStep();
        try (RawDocument rawDoc = new RawDocument((CharSequence)this.htmlSnippet, this.locEN);){
            File tmpFile = File.createTempFile("~okapi-1_", ".tmp");
            this.eventToDoc.setOutputURI(tmpFile.toURI());
            this.eventToDoc.setOutputEncoding("UTF-8");
            this.htmlFilter.open(rawDoc);
            while (this.htmlFilter.hasNext()) {
                event = this.eventToDoc.handleEvent(this.htmlFilter.next());
            }
            this.htmlFilter.close();
            Assert.assertNotNull(event);
            Assert.assertTrue((event.getEventType() == EventType.RAW_DOCUMENT ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.htmlSnippet, (Object)this.convertRawDocumentToString((RawDocument)event.getResource()));
            this.eventToDoc.destroy();
        }
    }

    @Test
    public void htmlEventsToRawDocument() throws IOException {
        Event event = null;
        this.eventToDoc = new FilterEventsToRawDocumentStep();
        try (RawDocument rawDoc = new RawDocument((CharSequence)this.htmlSnippet, this.locEN);){
            this.eventToDoc.setOutputEncoding("UTF-8");
            this.htmlFilter.open(rawDoc);
            while (this.htmlFilter.hasNext()) {
                event = this.eventToDoc.handleEvent(this.htmlFilter.next());
            }
            this.htmlFilter.close();
            Assert.assertNotNull(event);
            Assert.assertTrue((event.getEventType() == EventType.RAW_DOCUMENT ? 1 : 0) != 0);
            Assert.assertEquals((Object)this.htmlSnippet, (Object)this.convertRawDocumentToString((RawDocument)event.getResource()));
            this.eventToDoc.destroy();
        }
    }

    private String convertRawDocumentToString(RawDocument d) throws IOException {
        StringWriter sw = new StringWriter();
        try (Reader r = d.getReader();){
            int c;
            while ((c = r.read()) != -1) {
                sw.append((char)c);
            }
        }
        return sw.toString();
    }
}

