/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.integration.BaseRoundTripIT;
import net.sf.okapi.common.integration.IComparator;
import net.sf.okapi.common.integration.OkapiTestException;
import net.sf.okapi.common.integration.RoundTripUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XmlOrTextRoundTripIT
extends BaseRoundTripIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Rule
    public ErrorCollector errCol = new ErrorCollector();

    public XmlOrTextRoundTripIT(String configId, String dirName, List<String> extensions) {
        super(configId, dirName, extensions);
    }

    public XmlOrTextRoundTripIT(String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale) {
        super(configId, dirName, extensions, defaultTargetLocale);
    }

    @Override
    protected void runTest(boolean detectLocales, File file, File subDir, String customConfigPath, IComparator comparator) {
        String f = file.getName();
        String root = file.getParent() + File.separator;
        String xliff = root + f + this.xliffExtractedExtension;
        String original = root + f;
        String tkitMerged = root + f + ".tkitMerged";
        LocaleId source = LocaleId.ENGLISH;
        LocaleId target = this.defaultTargetLocale;
        if (detectLocales) {
            List locales = FileUtil.guessLanguages((String)file.getAbsolutePath());
            if (locales.size() >= 1) {
                source = LocaleId.fromString((String)((String)locales.get(0)));
            }
            if (locales.size() >= 2) {
                target = LocaleId.fromString((String)((String)locales.get(1)));
            }
        }
        try {
            this.logger.info(f);
            FilterConfigurationMapper mapper = RoundTripUtils.extract(source, target, original, xliff, this.configId, customConfigPath);
            RoundTripUtils.merge(source, target, original, xliff, tkitMerged, this.configId, customConfigPath, mapper);
            Assert.assertTrue((String)("Compare XML: " + f), (boolean)comparator.compare(Paths.get(original, new String[0]), Paths.get(tkitMerged, new String[0])));
        }
        catch (Throwable e) {
            if (!this.knownFailingFiles.contains(f)) {
                this.errCol.addError((Throwable)((Object)new OkapiTestException(f, e)));
                this.logger.error("Failing test: {}\n{}", (Object)f, (Object)e.getMessage());
            }
            this.logger.info("Ignored known failing file: {}", (Object)f);
        }
    }
}

