/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.FilterTestUtil;
import net.sf.okapi.common.integration.ArchiveFileCompare;
import net.sf.okapi.common.integration.IComparator;
import net.sf.okapi.common.integration.RoundTripUtils;
import net.sf.okapi.common.resource.ITextUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.diff.Diff;
import org.xmlunit.diff.Difference;
import org.xmlunit.diff.DifferenceEvaluator;

public final class FileComparator {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileComparator.class);

    private FileComparator() {
    }

    public static class XmlComparator<T>
    implements IComparator<T> {
        @Override
        public boolean compare(T actual, T expected) {
            try {
                boolean pass;
                Diff documentDiff = FilterTestUtil.compareXml(actual, expected, (boolean)true, (DifferenceEvaluator[])new DifferenceEvaluator[0]);
                boolean bl = pass = !documentDiff.hasDifferences();
                if (!pass) {
                    LOGGER.error("XML Differences:");
                    for (Difference d : documentDiff.getDifferences()) {
                        LOGGER.error("+ {}", (Object)d.toString());
                    }
                }
                return pass;
            }
            catch (ParserConfigurationException e) {
                throw new OkapiBadFilterInputException("XML Parse Error: ", (Throwable)e);
            }
        }
    }

    public static class ArchiveComparator
    implements IComparator<Path> {
        @Override
        public boolean compare(Path actual, Path expected) {
            ArchiveFileCompare ac = new ArchiveFileCompare(new XmlComparator());
            return ac.compareFiles(actual, expected);
        }
    }

    public static class EventComparatorIgnoreSegmentation
    implements IComparator<List<Event>> {
        @Override
        public boolean compare(List<Event> actual, List<Event> expected) {
            return RoundTripUtils.compareEvents(actual, expected, true, false, false, true);
        }
    }

    public static class EventComparatorWithWhitespace
    implements IComparator<List<Event>> {
        @Override
        public boolean compare(List<Event> actual, List<Event> expected) {
            return RoundTripUtils.compareEvents(actual, expected, true, false, false, false);
        }
    }

    public static class EventComparatorTextUnitOnly
    implements IComparator<List<ITextUnit>> {
        @Override
        public boolean compare(List<ITextUnit> actual, List<ITextUnit> expected) {
            return RoundTripUtils.compareTextUnits(actual, expected, true);
        }
    }

    public static class EventComparator
    implements IComparator<List<Event>> {
        @Override
        public boolean compare(List<Event> actual, List<Event> expected) {
            return RoundTripUtils.compareEvents(actual, expected, false, true, true, false);
        }
    }

    public static class Utf8FilePerLineComparator
    implements IComparator<Path> {
        @Override
        public boolean compare(Path actual, Path expected) {
            return new FileCompare().compareFilesPerLines(actual.toString(), expected.toString(), StandardCharsets.UTF_8.name());
        }
    }
}

