/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiFilterCreationException;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.Parameters;
import net.sf.okapi.common.filterwriter.TMXFilterWriter;
import net.sf.okapi.common.integration.EventRoundTripIT;
import net.sf.okapi.common.integration.IComparator;
import net.sf.okapi.common.integration.IntegrationtestUtils;
import net.sf.okapi.common.integration.OkapiTestException;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.po.POFilter;
import net.sf.okapi.filters.table.TableFilter;
import net.sf.okapi.filters.tmx.TmxFilter;
import net.sf.okapi.filters.xliff.XLIFFFilter;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionCompareIT
extends EventRoundTripIT {
    public static final String XLIFF_CONFIG = StreamUtil.streamUtf8AsString((InputStream)ConversionCompareIT.class.getClassLoader().getResourceAsStream("bilingual/okf_xliff@tm-import.fprm"));
    public static final String TMX_CONFIG = StreamUtil.streamUtf8AsString((InputStream)ConversionCompareIT.class.getClassLoader().getResourceAsStream("bilingual/okf_tmx@tm-import.fprm"));
    public static final String TABLE_CONFIG = StreamUtil.streamUtf8AsString((InputStream)ConversionCompareIT.class.getClassLoader().getResourceAsStream("bilingual/okf_table@tm-import.fprm"));
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ConversionCompareIT(String configId, String dirName, List<String> extensions) {
        super(configId, dirName, extensions);
    }

    public ConversionCompareIT(String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale) {
        super(configId, dirName, extensions, defaultTargetLocale);
    }

    @Override
    public void runTest(boolean detectLocales, File file, File subDir, String customConfigPath, IComparator comparator) {
        String f = file.getName();
        String root = file.getParent() + File.separator;
        String original = root + f;
        String tmxConverted = root + f + ".converted_tmx";
        String xliffConverted = root + f + ".converted_xliff";
        LocaleId source = LocaleId.ENGLISH;
        LocaleId target = this.defaultTargetLocale;
        if (detectLocales) {
            List locales = FileUtil.guessLanguages((String)file.getAbsolutePath());
            if (locales.size() >= 1) {
                source = LocaleId.fromString((String)((String)locales.get(0)));
            }
            if (locales.size() >= 2) {
                target = LocaleId.fromString((String)((String)locales.get(1)));
            }
        }
        try {
            this.logger.info(f);
            IFilter bilingualFilter = this.createBilingualFilter(this.configId);
            IFilter tmxFilter = this.createBilingualFilter("okf_tmx");
            if (bilingualFilter == null || tmxFilter == null) {
                throw new OkapiFilterCreationException(String.format("Cannot create okapi bilingual filter: %s", this.configId));
            }
            this.convert(original, source, target, tmxConverted, bilingualFilter);
            try (RawDocument ord = new RawDocument(Util.toURI((String)original), "UTF-8", source, target);
                 RawDocument trd = new RawDocument(Util.toURI((String)tmxConverted), "UTF-8", source, target);){
                ArrayList<ITextUnit> o = IntegrationtestUtils.getTextUnitEvents(bilingualFilter, ord, null);
                ArrayList<ITextUnit> t = IntegrationtestUtils.getTextUnitEvents(tmxFilter, trd, null);
                Assert.assertTrue((String)("Compare Events (TMX): " + f), (boolean)comparator.compare(o, t));
            }
        }
        catch (Throwable e) {
            if (!this.knownFailingFiles.contains(f)) {
                this.errCol.addError((Throwable)((Object)new OkapiTestException(f, e)));
                this.logger.error("Failing test: {}\n{}", (Object)f, (Object)e.getMessage());
            }
            this.logger.info("Ignored known failing file: {}", (Object)f);
        }
    }

    public void convert(String original, LocaleId sourceLocale, LocaleId targetLocale, String tmxConverted, IFilter bilingualFilter) throws OkapiTestException, IOException {
        try (TMXFilterWriter tmxWriter = new TMXFilterWriter();){
            bilingualFilter.open(new RawDocument(Util.toURI((String)original), StandardCharsets.UTF_8.name(), sourceLocale, targetLocale));
            Parameters tmxWriterParams = tmxWriter.getParameters();
            tmxWriter.setOptions(targetLocale, StandardCharsets.UTF_8.name());
            tmxWriter.setOutput(tmxConverted);
            tmxWriterParams.setWriteAllPropertiesAsAttributes(true);
            tmxWriterParams.setAutoGenerateTuId(false);
            tmxWriter.setParameters((IParameters)tmxWriterParams);
            while (bilingualFilter.hasNext()) {
                Event event = bilingualFilter.next();
                tmxWriter.handleEvent(event);
            }
        }
        catch (OkapiException e) {
            String m = String.format("Error converting file type %s to TMX", this.configId);
            throw new OkapiTestException(m, e);
        }
    }

    private IFilter createBilingualFilter(String configId) {
        XLIFFFilter bilingualFilter = null;
        switch (configId) {
            case "okf_xliff": {
                bilingualFilter = new XLIFFFilter();
                IParameters p = bilingualFilter.getParameters();
                p.fromString(XLIFF_CONFIG);
                break;
            }
            case "okf_po": {
                bilingualFilter = new POFilter();
                break;
            }
            case "okf_table": {
                bilingualFilter = new TableFilter();
                IParameters p = bilingualFilter.getParameters();
                p.fromString(TABLE_CONFIG);
                break;
            }
            case "okf_tmx": {
                bilingualFilter = new TmxFilter();
                IParameters p = bilingualFilter.getParameters();
                p.fromString(TMX_CONFIG);
                break;
            }
        }
        return bilingualFilter;
    }
}

