/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.integration.IComparator;
import net.sf.okapi.common.integration.IntegrationtestUtils;
import org.junit.Rule;
import org.junit.rules.ErrorCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRoundTripIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    final String defaultConfigId;
    protected String configId;
    final String dirName;
    List<String> extensions;
    final LocaleId defaultTargetLocale;
    final Set<String> knownFailingFiles = new HashSet<String>();
    final String xliffExtractedExtension;
    protected IFilter filter;
    @Rule
    public ErrorCollector errCol = new ErrorCollector();

    public BaseRoundTripIT(String configId, String dirName, List<String> extensions) {
        this(configId, dirName, extensions, LocaleId.FRENCH);
    }

    public BaseRoundTripIT(String configId, String dirName, List<String> extensions, LocaleId defaultTargetLocale) {
        this.defaultConfigId = configId;
        this.configId = configId;
        this.dirName = dirName;
        this.extensions = extensions;
        this.defaultTargetLocale = defaultTargetLocale;
        this.xliffExtractedExtension = configId.startsWith("okf_xliff") ? ".xliff_extracted" : ".xliff";
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    public void addKnownFailingFile(String fileName) {
        this.knownFailingFiles.add(fileName);
    }

    public void realTestFiles(boolean detectLocales, IComparator comparator) throws FileNotFoundException, URISyntaxException {
        File dir = IntegrationtestUtils.ROOT.in(this.dirName).asFile();
        for (File file : IntegrationtestUtils.getTestFilesNoRecurse(dir, this.extensions)) {
            this.runTest(detectLocales, file, null, null, comparator);
        }
        for (File subDir : IntegrationtestUtils.getSubDirsNoRecurse(dir)) {
            for (File file : IntegrationtestUtils.getTestFilesNoRecurse(subDir, this.extensions)) {
                Collection<File> configs = IntegrationtestUtils.getConfigFile(subDir);
                if (configs.isEmpty()) {
                    this.setConfigId(this.defaultConfigId);
                    this.runTest(detectLocales, file, subDir, null, comparator);
                    continue;
                }
                for (File c : configs) {
                    this.setConfigId(Util.getFilename((String)c.getAbsolutePath(), (boolean)false));
                    String customConfigPath = c.getParent();
                    this.runTest(detectLocales, file, subDir, customConfigPath, comparator);
                }
            }
        }
    }

    protected abstract void runTest(boolean var1, File var2, File var3, String var4, IComparator var5);
}

