/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.integration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.integration.IComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveFileCompare {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final IComparator comparator;
    private final List<String> fileExtensions;

    public ArchiveFileCompare(IComparator comparator) {
        this.comparator = comparator;
        this.fileExtensions = new LinkedList<String>();
        this.fileExtensions.add(".xml");
        this.fileExtensions.add(".rels");
        this.fileExtensions.add(".xlf");
        this.fileExtensions.add(".xliff");
        this.fileExtensions.add(".tmx");
    }

    public ArchiveFileCompare(IComparator comparator, List<String> fileExtensions) {
        this(comparator);
        this.fileExtensions.addAll(fileExtensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compareFiles(Path out, Path gold) {
        ZipFile goldZipFile = null;
        ZipFile outZipFile = null;
        Enumeration<? extends ZipEntry> outEntries = null;
        Enumeration<? extends ZipEntry> goldEntries = null;
        try {
            ZipEntry ze;
            HashMap<String, ZipEntry> outZipMap = new HashMap<String, ZipEntry>();
            HashMap<String, ZipEntry> goldZipMap = new HashMap<String, ZipEntry>();
            try {
                File outZip = out.toFile();
                outZipFile = new ZipFile(outZip);
                outEntries = outZipFile.entries();
            }
            catch (Exception e) {
                this.LOGGER.error("ZipCompare:  Output file {} not found.\n", (Object)out);
                this.LOGGER.error(out.getFileName().toString());
                boolean bl = false;
                if (outZipFile != null) {
                    try {
                        outZipFile.close();
                    }
                    catch (IOException e2) {
                        this.LOGGER.error("Error closing zip file", (Throwable)e2);
                    }
                }
                if (goldZipFile == null) return bl;
                try {
                    goldZipFile.close();
                    return bl;
                }
                catch (IOException e3) {
                    this.LOGGER.error("Error closing zip file", (Throwable)e3);
                }
                return bl;
            }
            try {
                File goldZip = gold.toFile();
                goldZipFile = new ZipFile(goldZip);
                goldEntries = goldZipFile.entries();
            }
            catch (Exception e) {
                this.LOGGER.error("ZipCompare:  Gold file {} not found.\n", (Object)gold);
                this.LOGGER.error(out.getFileName().toString());
                boolean bl = false;
                if (outZipFile != null) {
                    try {
                        outZipFile.close();
                    }
                    catch (IOException e4) {
                        this.LOGGER.error("Error closing zip file", (Throwable)e4);
                    }
                }
                if (goldZipFile == null) return bl;
                try {
                    goldZipFile.close();
                    return bl;
                }
                catch (IOException e5) {
                    this.LOGGER.error("Error closing zip file", (Throwable)e5);
                }
                return bl;
            }
            while (outEntries.hasMoreElements()) {
                ze = outEntries.nextElement();
                outZipMap.put(ze.getName(), ze);
            }
            while (goldEntries.hasMoreElements()) {
                ze = goldEntries.nextElement();
                goldZipMap.put(ze.getName(), ze);
            }
            if (outZipMap.size() != goldZipMap.size()) {
                this.LOGGER.error("Difference in number of files:");
                this.LOGGER.error(" out: {}", (Object)outZipMap.size());
                this.LOGGER.error("gold: {}", (Object)(goldZipMap.size() + "\n"));
                this.LOGGER.error(out.getFileName().toString());
                boolean ze2 = false;
                return ze2;
            }
            if (!outZipMap.keySet().equals(goldZipMap.keySet())) {
                this.LOGGER.error("Filenames do not match between the zipfiles\n");
                this.LOGGER.error(out.getFileName().toString());
                boolean ze2 = false;
                return ze2;
            }
            boolean pass = false;
            try {
                for (String filename : outZipMap.keySet()) {
                    ZipEntry oze = (ZipEntry)outZipMap.get(filename);
                    ZipEntry gze = (ZipEntry)goldZipMap.get(filename);
                    if (oze.getSize() <= 0L && gze.getSize() <= 0L) continue;
                    InputStream ois = outZipFile.getInputStream(oze);
                    InputStream gis = goldZipFile.getInputStream(gze);
                    if (!this.isContent(oze.getName()) || !this.isContent(gze.getName()) || (pass = this.comparator.compare(ois, gis))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception e) {
                this.LOGGER.error("Error opening/reading file\n");
                this.LOGGER.error(out.getFileName().toString());
                boolean filename = false;
                if (outZipFile != null) {
                    try {
                        outZipFile.close();
                    }
                    catch (IOException e6) {
                        this.LOGGER.error("Error closing zip file", (Throwable)e6);
                    }
                }
                if (goldZipFile == null) return filename;
                try {
                    goldZipFile.close();
                    return filename;
                }
                catch (IOException e7) {
                    this.LOGGER.error("Error closing zip file", (Throwable)e7);
                }
                return filename;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (outZipFile != null) {
                try {
                    outZipFile.close();
                }
                catch (IOException e) {
                    this.LOGGER.error("Error closing zip file", (Throwable)e);
                }
            }
            if (goldZipFile != null) {
                try {
                    goldZipFile.close();
                }
                catch (IOException e) {
                    this.LOGGER.error("Error closing zip file", (Throwable)e);
                }
            }
        }
    }

    private boolean isContent(String fileName) {
        String ext = Util.getExtension((String)fileName);
        for (String s : this.fileExtensions) {
            if (!s.equalsIgnoreCase(ext)) continue;
            return true;
        }
        return false;
    }
}

