/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow;

import java.io.File;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.html.HtmlFilter;
import net.sf.okapi.filters.properties.PropertiesFilter;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class DevelopersGuideIT {
    private FileLocation location = FileLocation.fromClass(this.getClass());

    @Test
    public void testRawDoc() {
        try (RawDocument res = new RawDocument((CharSequence)"key1=Text1\nkey2=Text2", LocaleId.fromString((String)"en"));
             PropertiesFilter filter = new PropertiesFilter();){
            filter.open(res);
            while (filter.hasNext()) {
                Event event = filter.next();
                if (event.getEventType() != EventType.TEXT_UNIT) continue;
                TextUnit tu = (TextUnit)event.getResource();
                System.out.println("--");
                System.out.println("key=[" + tu.getName() + "]");
                System.out.println("text=[" + tu.getSource() + "]");
            }
        }
    }

    @Test
    public void testModify() {
        File outFile = this.location.out("/myFile_fr.html").asFile();
        try (HtmlFilter filter = new HtmlFilter();){
            LocaleId trgLoc = LocaleId.fromString((String)"fr");
            filter.open(new RawDocument((CharSequence)"<html><head>\n<meta http-equiv='Content-Language' content='en'></head>\n<body>\n<p>Text in <b>bold</b>.</p></body></html>", LocaleId.fromString((String)"en"), trgLoc));
            IFilterWriter writer = filter.createFilterWriter();
            writer.setOptions(trgLoc, "iso-8859-1");
            writer.setOutput(outFile.getAbsolutePath());
            while (filter.hasNext()) {
                Event event = filter.next();
                if (event.getEventType() == EventType.TEXT_UNIT) {
                    this.changeTU(event.getTextUnit());
                }
                writer.handleEvent(event);
            }
        }
        Assert.assertTrue((boolean)outFile.exists());
    }

    private void changeTU(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer tc = tu.createTarget(LocaleId.fromString((String)"fr"), false, 7);
        ISegments segs = tc.getSegments();
        for (Segment seg : segs) {
            TextFragment tf = seg.getContent();
            tf.setCodedText(tf.getCodedText().toUpperCase());
        }
    }
}

