/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.tikal;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.StreamGobbler;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.ZipFileCompare;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=JUnit4.class)
public class TikalIT {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String[] javaTikal;
    private FileCompare fc = new FileCompare();
    private ZipFileCompare zfc = new ZipFileCompare();
    private FileLocation root;

    @Before
    public void setUp() throws URISyntaxException {
        this.root = FileLocation.fromClass(this.getClass());
        String osName = System.getProperty("os.name");
        String distDir = osName.contains("OS X") ? (System.getProperty("os.arch").equals("x86_64") || System.getProperty("os.arch").equals("amd64") ? "dist_cocoa-macosx-x86_64" : "dist_cocoa-macosx") : (osName.startsWith("Windows") ? (System.getProperty("os.arch").equals("x86_64") || System.getProperty("os.arch").equals("amd64") ? "dist_win32-x86_64" : "dist_win32-x86") : (System.getProperty("os.arch").equals("x86_64") || System.getProperty("os.arch").equals("amd64") ? "dist_gtk2-linux-x86_64" : "dist_gtk2-linux-x86"));
        String libDir = Util.getDirectoryName((String)this.root.in("/").toString());
        libDir = Util.getDirectoryName((String)libDir);
        libDir = Util.getDirectoryName((String)libDir);
        libDir = Util.getDirectoryName((String)libDir);
        libDir = libDir + String.format("%sdeployment%smaven%s%s%slib%s", File.separator, File.separator, File.separator, distDir, File.separator, File.separator);
        this.javaTikal = new String[]{"java", "-cp", libDir + "/*", "net.sf.okapi.applications.tikal.Main"};
    }

    @Test
    public void testSimpleCall() throws IOException, InterruptedException {
        Assert.assertEquals((long)0L, (long)this.runTikal(""));
    }

    @Test
    public void testHelpCall() throws IOException, InterruptedException {
        Assert.assertEquals((long)0L, (long)this.runTikal("-?"));
    }

    @Test
    public void testExtractMergeDTD() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("dtdtest.dtd.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("dtdtest.out.dtd"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr dtdtest.dtd -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("dtdtest.dtd.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr dtdtest.dtd.xlf -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("dtdtest.out.dtd", "windows-1252"));
    }

    @Test
    public void testExtractMergeHTML() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("htmltest.html.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("htmltest.out.html"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr htmltest.html -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("htmltest.html.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr htmltest.html.xlf -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("htmltest.out.html", "windows-1252"));
    }

    @Test
    public void testExtractMergeJSON() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("jsontest.json.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("jsontest.out.json"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr jsontest.json -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("jsontest.json.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr jsontest.json.xlf -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("jsontest.out.json", "windows-1252"));
    }

    @Test
    public void testExtractMergePO() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.out.po"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr potest.po -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr potest.po.xlf -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.out.po", "windows-1252"));
    }

    @Test
    public void testExtractMergePOMono() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("potest-mono.po.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest-mono.out.po"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr potest-mono.po -fc okf_po-monolingual -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest-mono.po.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr potest-mono.po.xlf -fc okf_po-monolingual -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest-mono.out.po", "windows-1252"));
    }

    @Test
    public void testExtractMergeProperties() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("proptest.properties.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("proptest.out.properties"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr proptest.properties -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("proptest.properties.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr proptest.properties.xlf -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("proptest.out.properties", "windows-1252"));
    }

    @Test
    public void testExtractMergePropertiesNoEscapes() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("proptest.properties.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("proptest.out.noesc.properties"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr proptest.properties -fc okf_properties-outputNotEscaped -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("proptest.properties.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr proptest.properties.xlf -fc okf_properties-outputNotEscaped -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("proptest.out.properties", "proptest.out.noesc.properties", "windows-1252"));
    }

    @Test
    public void testExtractMergeODT() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("odttest.odt.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("odttest.out.odt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr odttest.odt -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("odttest.odt.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr odttest.odt.xlf"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareZipWithGoldFile("odttest.out.odt"));
    }

    @Test
    public void testExtractMergeODS() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("odstest.ods.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("odstest.out.ods"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr odstest.ods -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("odstest.ods.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr odstest.ods.xlf"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareZipWithGoldFile("odstest.out.ods"));
    }

    @Test
    public void testExtractMergeDOCX() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("docxtest.docx.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("docxtest.out.docx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr docxtest.docx -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("docxtest.docx.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr docxtest.docx.xlf"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareZipWithGoldFile("docxtest.out.docx"));
    }

    @Test
    public void testExtractSegmentMergeDOCX() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("docxsegtest.docx.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("docxsegtest.out.docx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr docxsegtest.docx -seg -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("docxsegtest.docx.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr docxsegtest.docx.xlf"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareZipWithGoldFile("docxsegtest.out.docx"));
    }

    @Test
    public void testExtractMergeTMX() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("tmxtest-attributes.tmx.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("tmxtest-attributes.out.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 tmxtest-attributes.tmx -sl EN-US -tl FR-FR -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("tmxtest-attributes.tmx.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 tmxtest-attributes.tmx.xlf -sl EN-US -tl FR-FR -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("tmxtest-attributes.out.tmx", "windows-1252"));
    }

    @Test
    public void testExtractMergeIDML() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("idmltest.idml.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("idmltest.out.idml"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr idmltest.idml -ie UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("idmltest.idml.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr idmltest.idml.xlf"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareZipWithGoldFile("idmltest.out.idml"));
    }

    @Test
    public void testExtractMergeTS() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("tstest.ts.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("tstest.out.ts"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr tstest.ts -sl EN-US -tl FR-FR -ie UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("tstest.ts.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr tstest.ts.xlf -sl EN-US -tl FR-FR -oe UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("tstest.out.ts", "windows-1252"));
    }

    @Test
    public void testExtractMergeXLIFF() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("xlifftest.xlf.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("xlifftest.out.xlf"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr xlifftest.xlf"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("xlifftest.xlf.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr xlifftest.xlf.xlf -oe windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("xlifftest.out.xlf", "UTF-8"));
    }

    @Test
    public void testExtractMergeXML() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("xmltest1.xml.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("xmltest1.out.xml"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr xmltest1.xml -ie UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("xmltest1.xml.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr xmltest1.xml.xlf -oe UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("xmltest1.out.xml", "UTF-8"));
    }

    @Test
    public void testExtractMergeStreamedXML() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("xmltest3.xml.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("xmltest3.out.xml"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr xmltest3.xml -fc okf_xmlstream -ie UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("xmltest3.xml.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr xmltest3.xml.xlf -fc okf_xmlstream -oe UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("xmltest3.out.xml", "UTF-8"));
    }

    @Test
    public void testExtractMergeTSV() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("tsvtest.txt.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("tsvtest.out.txt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr tsvtest.txt -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("tsvtest.txt.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr tsvtest.txt.xlf -oe UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("tsvtest.out.txt", "UTF-8"));
    }

    @Test
    public void testExtractMergeRESX() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("resxtest.resx.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("resxtest.out.resx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr resxtest.resx"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("resxtest.resx.xlf", "UTF-8"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr resxtest.resx.xlf -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("resxtest.out.resx", "windows-1252"));
    }

    @Test
    public void testExtractMergeSRT() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("srttest.srt.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("srttest.out.srt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr srttest.srt -ie windows-1252"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("srttest.srt.xlf", "windows-1252"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr srttest.srt.xlf -ie UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("srttest.out.srt", "UTF-8"));
    }

    @Test
    public void testExtractMergeYAML() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("yamltest.yml.xlf"));
        Assert.assertTrue((boolean)this.deleteOutputFile("yamltest.out.yml"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x1 -sl en -tl fr yamltest.yml -ie UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("yamltest.yml.xlf", "windows-1252"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m1 -sl en -tl fr yamltest.yml.xlf -ie UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("yamltest.out.yml", "UTF-8"));
    }

    @Test
    public void testImportExportPensieve() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputDir("pensieveTM.pentm", true));
        Assert.assertEquals((long)0L, (long)this.runTikal("-imp pensieveTM.pentm tmxtest-attributes.tmx -sl EN-US -tl FR-FR"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-q \"One entry in the TM.\" -pen pensieveTM.pentm -sl EN-US -tl FR-FR"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pensieveTM.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tmx pensieveTM.pentm -fc okf_pensieve -sl EN-US -tl FR-FR"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pensieveTM.pentm.tmx", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pensieveTM.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-exp pensieveTM.pentm -sl EN-US -tl FR-FR"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pensieveTM.pentm.tmx", "UTF-8"));
    }

    @Test
    public void testConvertToTMX() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tmx -sl en -tl fr potest.po"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.tmx", "potest.po.normal.tmx", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tmx -sl en -tl fr potest.po -trgsource"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.tmx", "potest.po.source.tmx", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tmx -sl en -tl fr potest.po -trgempty"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.tmx", "potest.po.empty.tmx", "UTF-8"));
    }

    @Test
    public void testConvertToTable() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.txt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tbl potest.po -csv -all"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.txt", "potest.po.normal.csv", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.txt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tbl potest.po -csv -generic -all"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.txt", "potest.po.generic.csv", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.txt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tbl potest.po -csv -tmx -all"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.txt", "potest.po.tmx.csv", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.txt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tbl potest.po -tab"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.txt", "potest.po.normal.tab", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.txt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tbl potest.po -tab -generic -all"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.txt", "potest.po.generic.tab", "UTF-8"));
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.po.txt"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2tbl potest.po -tab -xliffgx -all"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("potest.po.txt", "potest.po.xliffgx.tab", "UTF-8"));
    }

    @Test
    public void testConvertToPO() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("tmxtest-attributes.tmx.po"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-2po tmxtest-attributes.tmx -sl EN-US -tl FR-FR"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("tmxtest-attributes.tmx.po", "UTF-8"));
    }

    @Test
    public void zz1TestQuerySeveralConnectors() throws IOException, InterruptedException {
        Assert.assertEquals((long)0L, (long)this.runTikal("-imp pensieveTM tmxtest-attributes.tmx -sl EN-US -tl FR-FR"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-q \"Close the <b>application</b>.\" -sl EN-US -tl FR-FR -pen pensieveTM"));
        int res = this.runTikal("-q \"Close the <b>application</b>.\" -sl EN-US -tl FR-FR -pen pensieveTM -mm");
        if (res != 0) {
            this.logger.error("\n=============== WARNING ===============");
            this.logger.error("The test of querying several translation resources failed.");
            this.logger.error("This may be due to connection issues, or to real API problems with one of the connectors. Please check.");
            this.logger.error("=======================================");
        }
    }

    @Test
    public void testLeverageSegsNoCopy() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputDir("leverage-test-TM.pentm", true));
        Assert.assertEquals((long)0L, (long)this.runTikal("-imp leverage-test-TM leverage-test-TM.tmx -sl EN-US -tl FR-FR -logger"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x leverage-test.html -pen leverage-test-TM -seg -nocopy -sl EN-US -tl FR-FR"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m leverage-test.html.xlf -sl EN-US -tl FR-FR -oe UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("leverage-test.out.html", "UTF-8"));
    }

    @Test
    public void testLevergeFuzzyMatch() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputDir("leverage-test-TM.pentm", true));
        Assert.assertEquals((long)0L, (long)this.runTikal("-imp leverage-test-TM leverage-test-TM.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x docbook-example-causing-fuzzy-match.xml -fc okf_xml-docbook -pen leverage-test-TM -nocopy -sl en -tl fr"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m docbook-example-causing-fuzzy-match.xml.xlf -fc okf_xml-docbook -sl en -tl fr -oe UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("docbook-example-causing-fuzzy-match.out.xml", "UTF-8"));
    }

    @Test
    public void testBrokenupTagPairsBySegmentationLeverage() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputDir("leverage-test-TM.pentm", true));
        Assert.assertEquals((long)0L, (long)this.runTikal("-imp leverage-test-TM leverage-test-TM.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x leverage-seg-isolated-tag-test.html -pen leverage-test-TM -seg -nocopy -sl en -tl fr"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m leverage-seg-isolated-tag-test.html.xlf -sl en -tl fr -oe UTF-8"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("leverage-seg-isolated-tag-test.out.html", "UTF-8"));
    }

    @Ignore(value="Issue #1049")
    @Test
    public void testBrokenupTagPairsBySegmentationLeverage2() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputDir("leverage-test-TM.pentm", true));
        Assert.assertEquals((long)0L, (long)this.runTikal("-imp leverage-test-TM leverage-test-TM.tmx"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-x docbook-footnote-simpara.xml -pen leverage-test-TM -seg -nocopy -sl en -tl fr"));
        Assert.assertEquals((long)0L, (long)this.runTikal("-m docbook-footnote-simpara.xml.xlf -sl en -tl fr"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("docbook-footnote-simpara.out.xml", "UTF-8"));
    }

    @Test
    @Ignore
    public void zz2TestTranslateXML() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("xmltest2out.xml"));
        int res = this.runTikal("-t xmltest2.xml -sl en -tl af -tt -trace -oe UTF-8");
        if (res == 0) {
            Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("xmltest2.out.xml", "UTF-8"));
        } else {
            this.logger.error("\n=============== WARNING ===============");
            this.logger.error("This test did not pass because the translation resources failed.");
            this.logger.error("This may be due to connection issues, or to real API problems with one of the connectors. Please check.");
            this.logger.error("=======================================");
        }
    }

    private boolean compareZipWithGoldFile(String outputBase) {
        String outputPath = this.root.in("/" + outputBase).toString();
        String goldPath = this.root.in("/gold/" + outputBase).toString();
        this.logger.trace("Zipped file comparison");
        this.logger.trace("Output File: {}", (Object)outputPath);
        this.logger.trace("Gold File: {}", (Object)(goldPath + "\n"));
        return this.zfc.compareFilesPerLines(outputPath, goldPath, "UTF-8", true);
    }

    private boolean compareWithGoldFile(String outputBase, String encoding) throws FileNotFoundException {
        String outputPath = this.root.in("/" + outputBase).toString();
        String goldPath = this.root.in("/gold/" + outputBase).toString();
        return this.fc.compareFilesPerLines(outputPath, goldPath, encoding);
    }

    private boolean compareWithGoldFile(String outputBase, String goldBase, String encoding) throws FileNotFoundException {
        String outputPath = this.root.in("/" + outputBase).toString();
        String goldPath = this.root.in("/gold/" + goldBase).toString();
        return this.fc.compareFilesPerLines(outputPath, goldPath, encoding);
    }

    private boolean deleteOutputFile(String filename) {
        File f = this.root.in("/" + filename).asFile();
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    private boolean deleteOutputDir(String dirname, boolean relative) {
        File d = relative ? this.root.in("/" + dirname).asFile() : new File(dirname);
        if (d.isDirectory()) {
            String[] children = d.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteOutputDir(d.getAbsolutePath() + "/" + children[i], false);
                if (success) continue;
                return false;
            }
        }
        if (d.exists()) {
            return d.delete();
        }
        return true;
    }

    private int runTikal(String extraArgs) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : this.javaTikal) {
            args.add(arg);
        }
        for (String arg : extraArgs.split("\\s+")) {
            args.add(arg);
        }
        args.add("-logger");
        this.logger.info("");
        this.logger.info("cmd>===============================================================================");
        this.logger.info("cmd>{}", (Object)(extraArgs == null ? "" : " " + extraArgs));
        Process p = Runtime.getRuntime().exec(args.toArray(new String[0]), null, this.root.in("/").asFile());
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "err");
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), "out");
        errorGobbler.start();
        outputGobbler.start();
        return p.waitFor();
    }
}

