/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import net.sf.okapi.common.FileCompare;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.StreamGobbler;
import net.sf.okapi.common.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class RainbowIT {
    private String[] javaRainbow;
    private FileCompare fc = new FileCompare();
    private FileLocation root;

    @Before
    public void setUp() throws URISyntaxException {
        this.root = FileLocation.fromClass(this.getClass());
        String osName = System.getProperty("os.name");
        String distDir = osName.contains("OS X") ? (System.getProperty("os.arch").equals("x86_64") || System.getProperty("os.arch").equals("amd64") ? "dist_cocoa-macosx-x86_64" : "dist_cocoa-macosx") : (osName.startsWith("Windows") ? (System.getProperty("os.arch").equals("x86_64") || System.getProperty("os.arch").equals("amd64") ? "dist_win32-x86_64" : "dist_win32-x86") : (System.getProperty("os.arch").equals("x86_64") || System.getProperty("os.arch").equals("amd64") ? "dist_gtk2-linux-x86_64" : "dist_gtk2-linux-x86"));
        String libDir = Util.getDirectoryName((String)this.root.in("/").toString());
        libDir = Util.getDirectoryName((String)libDir);
        libDir = Util.getDirectoryName((String)libDir);
        libDir = Util.getDirectoryName((String)libDir);
        libDir = libDir + String.format("%sdeployment%smaven%s%s%slib%s", File.separator, File.separator, File.separator, distDir, File.separator, File.separator);
        this.javaRainbow = osName.contains("OS X") ? new String[]{"java", "-XstartOnFirstThread", "-cp", libDir + "/*", "net.sf.okapi.applications.rainbow.Main"} : new String[]{"java", "-cp", libDir + "/*", "net.sf.okapi.applications.rainbow.Main"};
    }

    @Test
    public void testRewriting() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("potest.rbout.po"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/textrewriting.rnb -pln pipelines/textrewriting.pln"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/potest.rbout.po"));
    }

    @Test
    public void testPipeline01() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/input01.out.html"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/test01.rnb -pln pipelines/test01.pln"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/input01.out.html"));
    }

    @Test
    public void testTMs() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/tm/out1.tmx"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/tm/test01.out1.html"));
        Assert.assertTrue((boolean)this.deleteOutputDir("pipelines/tm/out2.pentm", true));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/tm/test01.out3.html"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/tm/out4.mv.db"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/tm/test01.out5.html"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/tm/pass1.rnb -pln pipelines/tm/pass1.pln -pd pipelines/tm"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/tm/pass2.rnb -pln pipelines/tm/pass2.pln -pd pipelines/tm"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/tm/pass3.rnb -pln pipelines/tm/pass3.pln -pd pipelines/tm"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/tm/pass4.rnb -pln pipelines/tm/pass4.pln -pd pipelines/tm"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/tm/pass5.rnb -pln pipelines/tm/pass5.pln -pd pipelines/tm"));
        String basePath = this.root.in("/pipelines/tm/Test01.out1.html").toString();
        String outputPath = this.root.in("/pipelines/tm/Test01.out3.html").toString();
        Assert.assertTrue((String)"Pensive leveraged output is different", (boolean)this.fc.filesExactlyTheSame(outputPath, basePath));
        outputPath = this.root.in("/pipelines/tm/Test01.out5.html").toString();
        Assert.assertTrue((String)"Pensive leveraged output is different", (boolean)this.fc.filesExactlyTheSame(outputPath, basePath));
    }

    @Test
    public void testDiffLeverage1() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/diffleverage/myFile_en_new.out.html"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/diffleverage/diffleverage1.rnb -pln pipelines/diffleverage/diffleverage1.pln"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/diffleverage/myFile_en_new.out.html"));
    }

    @Test
    public void testLeverage() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/leverage/test01.out.html"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/leverage/test01.out.po"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/leverage/simpleTM.mv.db"));
        Assert.assertTrue((boolean)this.deleteOutputDir("pipelines/leverage/pensieveTM.pentm", true));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/leverage/output1.tmx"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/leverage/createSimpleTM.rnb -pln pipelines/leverage/createSimpleTM.pln"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/leverage/createPensieveTM.rnb -pln pipelines/leverage/createPensieveTM.pln"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/leverage/prepare1.rnb -pln pipelines/leverage/prepare1.pln"));
        Assert.assertTrue((String)"test01.out.html different from gold", (boolean)this.compareWithGoldFile("pipelines/leverage/test01.out.html"));
        Assert.assertTrue((String)"test01.out.po different from gold", (boolean)this.compareWithGoldFile("pipelines/leverage/test01.out.po"));
        Assert.assertTrue((String)"output1.tmx different from gold", (boolean)this.compareWithGoldFilePerLine("pipelines/leverage/output1.tmx", "UTF-8"));
    }

    @Test
    public void testEncodingConversion() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/testForEncoding1.out.html"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/testForEncoding2.out.html"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/encodingConversion.rnb -pln pipelines/encodingConversion.pln"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/testForEncoding1.out.html"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/testForEncoding2.out.html"));
    }

    @Test
    public void testBOMLBConversion() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/bomlbConversion1_utf8.out.txt"));
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/bomlbConversion2_utf16BE.out.txt"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/bomlbConversion.rnb -pln pipelines/bomlbConversion.pln"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/bomlbConversion1_utf8.out.txt"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/bomlbConversion2_utf16BE.out.txt"));
    }

    @Test
    public void testRTFConversion() throws IOException, InterruptedException {
        Assert.assertTrue((boolean)this.deleteOutputFile("pipelines/rtfConversion1.out.rtf"));
        Assert.assertEquals((long)0L, (long)this.runRainbow("-np -p pipelines/rtfConversion.rnb -pln pipelines/rtfConversion.pln"));
        Assert.assertTrue((String)"File different from gold", (boolean)this.compareWithGoldFile("pipelines/rtfConversion1.out.rtf", true));
    }

    private boolean compareWithGoldFile(String outputBase) {
        return this.compareWithGoldFile(outputBase, false);
    }

    private boolean compareWithGoldFile(String outputBase, boolean ignoreLineEnd) {
        String outputPath = this.root.in("/" + outputBase).toString();
        String goldPath = this.root.in("/gold/" + outputBase).toString();
        return ignoreLineEnd ? this.fc.compareFilesPerLines(outputPath, goldPath, "utf-8") : this.fc.filesExactlyTheSame(outputPath, goldPath);
    }

    private boolean compareWithGoldFilePerLine(String outputBase, String encoding) throws FileNotFoundException {
        String outputPath = this.root.in("/" + outputBase).toString();
        String goldPath = this.root.in("/gold/" + outputBase).toString();
        return this.fc.compareFilesPerLines(outputPath, goldPath, encoding);
    }

    private boolean deleteOutputFile(String filename) {
        File f = this.root.in("/" + filename).asFile();
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    public boolean deleteOutputDir(String dirname, boolean relative) {
        File d = relative ? this.root.in("/" + dirname).asFile() : new File(dirname);
        if (d.isDirectory()) {
            String[] children = d.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteOutputDir(d.getAbsolutePath() + "/" + children[i], false);
                if (success) continue;
                return false;
            }
        }
        if (d.exists()) {
            return d.delete();
        }
        return true;
    }

    private int runRainbow(String extraArgs) throws IOException, InterruptedException {
        ArrayList<String> args = new ArrayList<String>();
        for (String arg : this.javaRainbow) {
            args.add(arg);
        }
        for (String arg : extraArgs.split("\\s+")) {
            args.add(arg);
        }
        Process p = Runtime.getRuntime().exec(args.toArray(new String[0]), null, this.root.in("/").asFile());
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), "err");
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), "out");
        errorGobbler.start();
        outputGobbler.start();
        p.waitFor();
        return p.exitValue();
    }
}

