/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.pensieve;

import java.io.File;
import net.sf.okapi.common.FileLocation;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.pensieve.Parameters;
import net.sf.okapi.connectors.pensieve.PensieveTMConnector;
import net.sf.okapi.lib.translation.ITMQuery;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.common.TranslationUnitVariant;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;
import net.sf.okapi.tm.pensieve.writer.TmWriterFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=JUnit4.class)
public class PensieveTMConnectorTest {
    private ITMQuery connector;
    private LocaleId locENUS = LocaleId.fromString((String)"EN-US");
    private LocaleId locFRFR = LocaleId.fromString((String)"FR-FR");
    private FileLocation root;
    private String dbDirectory;

    @Before
    public void setUp() {
        this.root = FileLocation.fromClass(this.getClass());
        this.dbDirectory = this.root.out("/testtm").toString() + File.separator;
        Util.createDirectories((String)this.dbDirectory);
        this.connector = new PensieveTMConnector();
        Parameters params = new Parameters();
        params.setDbDirectory(this.dbDirectory);
        this.connector.setParameters((IParameters)params);
        this.connector.setLanguages(this.locENUS, this.locFRFR);
        this.connector.open();
    }

    @After
    public void tearDown() {
        if (this.connector != null) {
            this.connector.close();
            this.connector = null;
        }
    }

    @Test
    public void aaaTestCreateTM() {
        if (this.connector != null) {
            this.connector.close();
        }
        ITmWriter writer = TmWriterFactory.createFileBasedTmWriter((String)this.dbDirectory, (boolean)true);
        TranslationUnit tu = new TranslationUnit();
        TranslationUnitVariant tuv = new TranslationUnitVariant(this.locENUS, new TextFragment("Elephants cannot fly."));
        tu.setSource(tuv);
        tuv = new TranslationUnitVariant(this.locFRFR, new TextFragment("Les \u00e9l\u00e9phants ne peuvent pas voler."));
        tu.setTarget(tuv);
        writer.indexTranslationUnit(tu);
        tu = new TranslationUnit();
        TextFragment tf = new TextFragment("Elephants ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("cannot");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" fly.");
        tuv = new TranslationUnitVariant(this.locENUS, tf);
        tu.setSource(tuv);
        tf = new TextFragment("Les \u00e9l\u00e9phants ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("ne peuvent pas");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" voler.");
        tuv = new TranslationUnitVariant(this.locFRFR, tf);
        tu.setTarget(tuv);
        writer.indexTranslationUnit(tu);
        tu = new TranslationUnit();
        tf = new TextFragment("Elephants ");
        tf.append(TextFragment.TagType.OPENING, "g0", "<g0>");
        tf.append("cannot");
        tf.append(TextFragment.TagType.CLOSING, "g0", "</g0>");
        tf.append(" fly.");
        tuv = new TranslationUnitVariant(this.locENUS, tf);
        tu.setSource(tuv);
        tf = new TextFragment("Les \u00e9l\u00e9phants ");
        tf.append(TextFragment.TagType.OPENING, "g0", "<g0>");
        tf.append("ne peuvent pas");
        tf.append(TextFragment.TagType.CLOSING, "g0", "</g0>");
        tf.append(" voler.");
        tuv = new TranslationUnitVariant(this.locFRFR, tf);
        tu.setTarget(tuv);
        writer.indexTranslationUnit(tu);
        writer.close();
    }

    @Test
    public void testGetMatches() {
        String input = "Elephants cannot fly.";
        this.connector.setThreshold(75);
        Assert.assertTrue((this.connector.query(input) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.connector.hasNext());
        QueryResult qr = this.connector.next();
        Assert.assertNotNull((Object)qr);
        Assert.assertEquals((Object)input, (Object)qr.source.toText());
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)qr.target.toText());
    }

    @Test
    public void testGetNoMatch() {
        this.connector.setThreshold(1);
        int n = this.connector.query("Otters can swim.");
        Assert.assertTrue((n == 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.connector.query("") == 0 ? 1 : 0) != 0);
        String tmp = null;
        Assert.assertTrue((this.connector.query(tmp) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetNoMatchWithCodes() {
        this.connector.setThreshold(1);
        Assert.assertTrue((this.connector.query(this.createOttersFragment()) == 0 ? 1 : 0) != 0);
        TextFragment tf = new TextFragment();
        Assert.assertTrue((this.connector.query(tf) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testGetExactMatch() {
        String input = "Elephants cannot fly.";
        this.connector.setThreshold(100);
        Assert.assertTrue((this.connector.query(input) > 0 ? 1 : 0) != 0);
        QueryResult qr = this.connector.next();
        Assert.assertEquals((Object)input, (Object)qr.source.toText());
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants ne peuvent pas voler.", (Object)qr.target.toText());
        Assert.assertEquals((long)100L, (long)qr.getFuzzyScore());
    }

    @Test
    public void testGetExactMatchWithCodes() {
        TextFragment tf = this.createElephantsFragment();
        this.connector.setThreshold(100);
        Assert.assertTrue((this.connector.query(tf) > 0 ? 1 : 0) != 0);
        QueryResult qr = this.connector.next();
        Assert.assertEquals((Object)tf.toText(), (Object)qr.source.toText());
        Assert.assertEquals((Object)"Les \u00e9l\u00e9phants <b>ne peuvent pas</b> voler.", (Object)qr.target.toText());
        Assert.assertEquals((long)100L, (long)qr.getFuzzyScore());
    }

    @Test
    public void testGetAlmostExactMatchWithCodes() {
        TextFragment tf = this.createElephantsFragment();
        this.connector.setThreshold(98);
        Assert.assertEquals((long)3L, (long)this.connector.query(tf));
        QueryResult qr = this.connector.next();
        Assert.assertEquals((long)100L, (long)qr.getFuzzyScore());
        qr = this.connector.next();
        Assert.assertEquals((long)100L, (long)qr.getFuzzyScore());
        qr = this.connector.next();
        Assert.assertTrue((qr.getFuzzyScore() != 100 ? 1 : 0) != 0);
    }

    private TextFragment createElephantsFragment() {
        TextFragment tf = new TextFragment("Elephants ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("cannot");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" fly.");
        return tf;
    }

    private TextFragment createOttersFragment() {
        TextFragment tf = new TextFragment("Otters ");
        tf.append(TextFragment.TagType.OPENING, "b", "<b>");
        tf.append("can");
        tf.append(TextFragment.TagType.CLOSING, "b", "</b>");
        tf.append(" swim.");
        return tf;
    }
}

