/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.mmt;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String URL = "url";
    private static final String CONTEXT = "context";

    public String getUrl() {
        return this.getString(URL);
    }

    public void setUrl(String url) {
        this.setString(URL, url);
    }

    public String getContext() {
        return this.getString(CONTEXT);
    }

    public void setContext(String context) {
        this.setString(CONTEXT, context);
    }

    public void reset() {
        super.reset();
        this.setUrl("");
        this.setContext("");
    }

    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription((Object)this);
        desc.add(URL, "URL for ModernMT Engine", "The ModernMT Engine's API URL - format http://<servername>:<port>");
        desc.add(CONTEXT, "Context for the ModernMT Engine calls", "Optional context description for the ModernMT engine calls");
        return desc;
    }

    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("ModernMT Engine Connector Settings", true, false);
        desc.addTextInputPart(paramsDesc.get(URL));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(CONTEXT));
        tip.setAllowEmpty(true);
        return desc;
    }
}

