/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.kantan;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.kantan.KantanMTv21Connector;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class KantanMTv21ConnectorMockitoTests {
    @Mock
    private CloseableHttpClient httpClient;
    @InjectMocks
    private KantanMTv21Connector connector;

    @Before
    public void setup() {
        this.initConnector();
        this.initMockHttpClient();
    }

    @Test
    public void testBatchQuery() throws IOException {
        CloseableHttpResponse mockResponse = this.mockHttpResponse(200, this.kantanJSONResponse("translation", this.translationDataJSON(Arrays.asList("First fragment", "Second fragment", "Third fragment"), Arrays.asList("Translated first fragment", "Translated second fragment", "Translated third fragment"))));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Matchers.any(HttpPost.class))).thenReturn((Object)mockResponse);
        List r = this.connector.batchQuery(this.generateTextFragments("First fragment", "Second fragment", "Third fragment"));
        Assert.assertEquals((long)3L, (long)r.size());
        Assert.assertEquals((Object)"Translated first fragment", (Object)((QueryResult)((List)r.get((int)0)).get((int)0)).target.toString());
        Assert.assertEquals((Object)"Translated second fragment", (Object)((QueryResult)((List)r.get((int)1)).get((int)0)).target.toString());
        Assert.assertEquals((Object)"Translated third fragment", (Object)((QueryResult)((List)r.get((int)2)).get((int)0)).target.toString());
    }

    @Test
    public void testQueryTextFragment() throws IOException {
        CloseableHttpResponse mockResponse = this.mockHttpResponse(200, this.kantanJSONResponse("translation", this.translationDataJSON(Arrays.asList("First fragment"), Arrays.asList("Translated first fragment"))));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Matchers.any(HttpPost.class))).thenReturn((Object)mockResponse);
        int i = this.connector.query(new TextFragment("First fragment"));
        Assert.assertEquals((long)1L, (long)i);
        Assert.assertTrue((boolean)this.connector.hasNext());
        Assert.assertEquals((Object)"Translated first fragment", (Object)this.connector.next().target.toString());
    }

    @Test
    public void testQuery() throws IOException {
        CloseableHttpResponse mockResponse = this.mockHttpResponse(200, this.kantanJSONResponse("translation", this.translationDataJSON(Arrays.asList("First fragment"), Arrays.asList("Translated first fragment"))));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)Matchers.any(HttpPost.class))).thenReturn((Object)mockResponse);
        int i = this.connector.query("First fragment");
        Assert.assertEquals((long)1L, (long)i);
        Assert.assertTrue((boolean)this.connector.hasNext());
        Assert.assertEquals((Object)"Translated first fragment", (Object)this.connector.next().target.toString());
    }

    private void initConnector() {
        this.connector.getParameters().setApiToken("fake_token");
        this.connector.getParameters().setEngine("fake_engine");
    }

    private void initMockHttpClient() {
    }

    private CloseableHttpResponse mockHttpResponse(int statusCode, String body) throws IOException {
        CloseableHttpResponse response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        StatusLine statusLine = (StatusLine)Mockito.mock(StatusLine.class);
        Mockito.when((Object)statusLine.getStatusCode()).thenReturn((Object)statusCode);
        HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(body.getBytes(StandardCharsets.UTF_8)));
        Mockito.when((Object)response.getStatusLine()).thenReturn((Object)statusLine);
        Mockito.when((Object)response.getEntity()).thenReturn((Object)httpEntity);
        return response;
    }

    private List<TextFragment> generateTextFragments(String ... src) {
        ArrayList<TextFragment> fragments = new ArrayList<TextFragment>();
        for (String s : src) {
            fragments.add(new TextFragment(s));
        }
        return fragments;
    }

    private String translationDataJSON(List<String> srcStrings, List<String> tgtStrings) {
        String templateTranslationData = "\"translationData\": [%s]";
        String templateTranslationItem = "{\"src\": \"%s\", \"trg\":\"%s\", \"id\": %d}";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < srcStrings.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.format(templateTranslationItem, srcStrings.get(i), tgtStrings.get(i), i));
        }
        return String.format(templateTranslationData, sb.toString());
    }

    private String kantanJSONResponse(String type, String body) {
        return String.format("{\"response\": {\"type\": \"%s\", \"body\": { %s }}}", type, body);
    }

    @Test
    public void testRoundTrip() {
        TextFragment frag = new TextFragment("This is ");
        frag.append(TextFragment.TagType.OPENING, "bold", "<B>");
        frag.append("bold");
        frag.append(TextFragment.TagType.CLOSING, "bold", "</B>");
        frag.append(" with ");
        frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "<BR/>");
        KantanMTv21Connector.RequestInfo ri = new KantanMTv21Connector.RequestInfo(frag);
        String html = ri.getPreparedText();
        TextFragment out = ri.generateResult(html);
        Assert.assertEquals((Object)frag.toText(), (Object)out.toText());
        Assert.assertFalse((out == frag ? 1 : 0) != 0);
    }
}

