/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.kantan;

import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.query.QueryResult;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.kantan.KantanMTv21Connector;
import net.sf.okapi.connectors.kantan.KantanMTv21ConnectorParameters;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class KantanMTv21ManualTests {
    private LocaleId srcLoc = LocaleId.fromBCP47((String)"en-US");
    private LocaleId trgLoc = LocaleId.fromBCP47((String)"fr-FR");
    private String apiToken = "";
    private String engine = "French_JD_20180303";

    @Test
    public void testQuery() {
        if (Util.isEmpty((String)this.apiToken)) {
            return;
        }
        try (KantanMTv21Connector conn = new KantanMTv21Connector();){
            KantanMTv21ConnectorParameters params = (KantanMTv21ConnectorParameters)conn.getParameters();
            params.setApiToken(this.apiToken);
            params.setEngine(this.engine);
            conn.open();
            conn.setLanguages(this.srcLoc, this.trgLoc);
            int count = conn.query("This is a test for the API.");
            Assert.assertEquals((long)1L, (long)count);
            QueryResult qr = conn.next();
            Assert.assertNotNull((Object)qr);
            System.out.println("src: " + qr.source.toText());
            System.out.println("trg: " + qr.target.toText());
        }
    }

    @Test
    public void testGetEngines() {
        if (Util.isEmpty((String)this.apiToken)) {
            return;
        }
        try (KantanMTv21Connector conn = new KantanMTv21Connector();){
            KantanMTv21ConnectorParameters params = (KantanMTv21ConnectorParameters)conn.getParameters();
            params.setApiToken(this.apiToken);
            conn.open();
            System.out.println(conn.getEngines());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueryWithTags() {
        if (Util.isEmpty((String)this.apiToken)) {
            return;
        }
        try (KantanMTv21Connector conn = null;){
            TextFragment frag = new TextFragment("This is ");
            frag.append(TextFragment.TagType.OPENING, "bold", "<B>");
            frag.append("bold + < and > and the characters @#$");
            frag.append(TextFragment.TagType.CLOSING, "bold", "</B>");
            frag.append(" with ");
            frag.append(TextFragment.TagType.PLACEHOLDER, "lb", "<BR/>");
            frag.append(" and &.");
            conn = new KantanMTv21Connector();
            KantanMTv21ConnectorParameters params = (KantanMTv21ConnectorParameters)conn.getParameters();
            params.setApiToken(this.apiToken);
            params.setEngine(this.engine);
            conn.setLanguages(LocaleId.fromBCP47((String)"en-US"), LocaleId.fromBCP47((String)"fr-FR"));
            conn.open();
            int count = conn.query(frag);
            Assert.assertEquals((long)1L, (long)count);
            QueryResult qr = conn.next();
            System.out.println("src: " + qr.source.toText());
            System.out.println("trg: " + qr.target.toText());
        }
    }
}

